/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import io.ktor.util.CryptoKt;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.NonCancellable;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\b\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0007H\u0002\u001a\b\u0010\u0015\u001a\u00020\u0013H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"INSECURE_NONCE_COUNT_FACTOR", "", "NONCE_SIZE_IN_BYTES", "NonceGeneratorCoroutineName", "Lkotlinx/coroutines/CoroutineName;", "SECURE_NONCE_COUNT", "SECURE_RANDOM_PROVIDER_NAME", "", "SECURE_RESEED_PERIOD", "SHA1PRNG", "nonceGeneratorJob", "Lkotlinx/coroutines/Job;", "seedChannel", "Lkotlinx/coroutines/channels/Channel;", "getSeedChannel", "()Lkotlinx/coroutines/channels/Channel;", "ensureNonceGeneratorRunning", "", "getInstanceOrNull", "Ljava/security/SecureRandom;", "name", "lookupSecureRandom", "ktor-utils"})
public final class NonceKt {
    @NotNull
    private static final String SHA1PRNG = "SHA1PRNG";
    @NotNull
    private static final String SECURE_RANDOM_PROVIDER_NAME;
    private static final int SECURE_RESEED_PERIOD = 30000;
    private static final int NONCE_SIZE_IN_BYTES = 8;
    private static final int SECURE_NONCE_COUNT = 8;
    private static final int INSECURE_NONCE_COUNT_FACTOR = 4;
    @NotNull
    private static final Channel<String> seedChannel;
    @NotNull
    private static final CoroutineName NonceGeneratorCoroutineName;
    @NotNull
    private static final Job nonceGeneratorJob;

    @NotNull
    public static final Channel<String> getSeedChannel() {
        return seedChannel;
    }

    public static final void ensureNonceGeneratorRunning() {
        nonceGeneratorJob.start();
    }

    private static final SecureRandom lookupSecureRandom() {
        SecureRandom secure = NonceKt.getInstanceOrNull(SECURE_RANDOM_PROVIDER_NAME);
        if (secure != null) {
            return secure;
        }
        LoggerFactory.getLogger((String)"io.ktor.util.random").warn(Intrinsics.stringPlus((String)SECURE_RANDOM_PROVIDER_NAME, (Object)" is not found, fallback to SHA1PRNG"));
        SecureRandom secureRandom = NonceKt.getInstanceOrNull(SHA1PRNG);
        if (secureRandom == null) {
            String string = "No SecureRandom implementation found";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return secureRandom;
    }

    private static final SecureRandom getInstanceOrNull(String name) {
        SecureRandom secureRandom;
        try {
            secureRandom = SecureRandom.getInstance(name);
        }
        catch (NoSuchAlgorithmException notFound) {
            secureRandom = null;
        }
        return secureRandom;
    }

    public static final /* synthetic */ SecureRandom access$lookupSecureRandom() {
        return NonceKt.lookupSecureRandom();
    }

    static {
        String string = System.getProperty("io.ktor.random.secure.random.provider");
        SECURE_RANDOM_PROVIDER_NAME = string == null ? "NativePRNGNonBlocking" : string;
        seedChannel = ChannelKt.Channel$default((int)1024, null, null, (int)6, null);
        NonceGeneratorCoroutineName = new CoroutineName("nonce-generator");
        nonceGeneratorJob = BuildersKt.launch((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)NonCancellable.INSTANCE).plus((CoroutineContext)NonceGeneratorCoroutineName), (CoroutineStart)CoroutineStart.LAZY, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            Object L$6;
            long J$0;
            int I$0;
            int I$1;
            int label;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var16_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        seedChannel = NonceKt.getSeedChannel();
                        lastReseed = 0L;
                        previousRoundNonceList = new ArrayList();
                        secureInstance = NonceKt.access$lookupSecureRandom();
                        weakRandom = SecureRandom.getInstance("SHA1PRNG");
                        secureBytes = new byte[64];
                        weakBytes = new byte[secureBytes.length * 4];
                        weakRandom.setSeed(secureInstance.generateSeed(secureBytes.length));
                        try {
                        }
                        catch (Throwable t) {
                            seedChannel.close(t);
                            SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)seedChannel), null, (int)1, null);
                            return Unit.INSTANCE;
                        }
                        catch (Throwable var10_13) {
                            SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)seedChannel), null, (int)1, null);
                            throw var10_13;
                        }
lbl27:
                        // 3 sources

                        while (true) {
                            secureInstance.nextBytes(secureBytes);
                            weakRandom.nextBytes(weakBytes);
                            var10_11 = 0;
                            var11_14 = secureBytes.length;
                            if (var10_11 < var11_14) {
                                do {
                                    i = var10_11++;
                                    weakBytes[i * 4] = secureBytes[i];
                                } while (var10_11 < var11_14);
                            }
                            if ((currentTime = System.currentTimeMillis()) - lastReseed > 30000L) {
                                weakRandom.setSeed(lastReseed - currentTime);
                                weakRandom.setSeed(secureInstance.generateSeed(secureBytes.length));
                                lastReseed = currentTime;
                            } else {
                                weakRandom.setSeed(secureBytes);
                            }
                            v0 = CollectionsKt.plus((Collection)StringsKt.chunked((CharSequence)CryptoKt.hex(weakBytes), (int)16), (Iterable)previousRoundNonceList);
                            Intrinsics.checkNotNullExpressionValue((Object)weakRandom, (String)"weakRandom");
                            randomNonceList = CollectionsKt.shuffled((Iterable)v0, (Random)weakRandom);
                            var13_17 = 0;
                            var14_18 = randomNonceList.size() / 2;
                            if (var13_17 < var14_18) {
                                while (true) {
                                    index = var13_17++;
                                    this.L$0 = seedChannel;
                                    this.L$1 = previousRoundNonceList;
                                    this.L$2 = secureInstance;
                                    this.L$3 = weakRandom;
                                    this.L$4 = secureBytes;
                                    this.L$5 = weakBytes;
                                    this.L$6 = randomNonceList;
                                    this.J$0 = lastReseed;
                                    this.I$0 = var13_17;
                                    this.I$1 = var14_18;
                                    this.label = 1;
                                    v1 = seedChannel.send(randomNonceList.get(index), (Continuation)this);
                                    if (v1 != var16_2) continue;
                                    return var16_2;
                                }
                            }
                            ** GOTO lbl81
                            break;
                        }
                    }
                    case 1: {
                        var14_18 = this.I$1;
                        var13_17 = this.I$0;
                        lastReseed = this.J$0;
                        randomNonceList = (List)this.L$6;
                        weakBytes = (byte[])this.L$5;
                        secureBytes = (byte[])this.L$4;
                        weakRandom = (SecureRandom)this.L$3;
                        secureInstance = (SecureRandom)this.L$2;
                        previousRoundNonceList = (ArrayList)this.L$1;
                        seedChannel = (Channel)this.L$0;
                        {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
                            if (var13_17 < var14_18) ** continue;
lbl81:
                            // 2 sources

                            previousRoundNonceList.clear();
                            var13_17 = randomNonceList.size() / 2;
                            if (var13_17 >= (var14_18 = randomNonceList.size())) ** GOTO lbl27
                            do {
                                index = var13_17++;
                                previousRoundNonceList.add(randomNonceList.get(index));
                            } while (var13_17 < var14_18);
                            ** continue;
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }
}

