/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\f\n\u0002\b\u0004\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0007\u001a\f\u0010\u0004\u001a\u00020\u0001*\u00020\u0001H\u0002\u001a\f\u0010\b\u001a\u00020\t*\u00020\nH\u0002\u001a\f\u0010\u000b\u001a\u00020\t*\u00020\nH\u0002\u001a\n\u0010\f\u001a\u00020\u0001*\u00020\u0001\u001a\f\u0010\r\u001a\u00020\u0001*\u00020\u0001H\u0002\u00a8\u0006\u000e"}, d2={"combineSafe", "Ljava/io/File;", "dir", "relativePath", "dropLeadingTopDirs", "", "path", "", "isPathSeparator", "", "", "isPathSeparatorOrDot", "normalizeAndRelativize", "notRooted", "ktor-utils"})
public final class PathKt {
    @NotNull
    public static final File combineSafe(@NotNull File $this$combineSafe, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)$this$combineSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        return PathKt.combineSafe($this$combineSafe, new File(relativePath));
    }

    @NotNull
    public static final File normalizeAndRelativize(@NotNull File $this$normalizeAndRelativize) {
        Intrinsics.checkNotNullParameter((Object)$this$normalizeAndRelativize, (String)"<this>");
        return PathKt.dropLeadingTopDirs(PathKt.notRooted(FilesKt.normalize((File)$this$normalizeAndRelativize)));
    }

    private static final File combineSafe(File dir, File relativePath) {
        File normalized = PathKt.normalizeAndRelativize(relativePath);
        if (FilesKt.startsWith((File)normalized, (String)"..")) {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Bad relative path ", (Object)relativePath));
        }
        boolean bl = !normalized.isAbsolute();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"Bad relative path ", (Object)relativePath);
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return new File(dir, normalized.getPath());
    }

    /*
     * WARNING - void declaration
     */
    private static final File notRooted(File $this$notRooted) {
        String string;
        String string2;
        block4: {
            Object parent;
            File file;
            if (!FilesKt.isRooted((File)$this$notRooted)) {
                return $this$notRooted;
            }
            File current = $this$notRooted;
            while ((file = current.getParentFile()) != null) {
                parent = file;
                current = parent;
            }
            parent = $this$notRooted.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)parent, (String)"path");
            String $this$dropWhile$iv = StringsKt.drop((String)parent, (int)current.getName().length());
            boolean $i$f$dropWhile = false;
            int n = 0;
            int n2 = ((CharSequence)$this$dropWhile$iv).length();
            while (n < n2) {
                void index$iv;
                char it = $this$dropWhile$iv.charAt((int)index$iv);
                boolean bl = false;
                if (!(it == '\\' || it == '/')) {
                    String string3 = $this$dropWhile$iv;
                    boolean bl2 = false;
                    String string4 = string3.substring((int)index$iv);
                    string2 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                    break block4;
                }
                ++index$iv;
            }
            string2 = "";
        }
        String string5 = string = string2;
        return new File(string5);
    }

    public static final int dropLeadingTopDirs(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        int startIndex = 0;
        int lastIndex = path.length() - 1;
        while (startIndex <= lastIndex) {
            int n;
            char first = path.charAt(startIndex);
            if (PathKt.isPathSeparator(first)) {
                n = startIndex;
                startIndex = n + 1;
                continue;
            }
            if (first != '.') break;
            if (startIndex == lastIndex) {
                n = startIndex;
                startIndex = n + 1;
                break;
            }
            char second = path.charAt(startIndex + 1);
            if (PathKt.isPathSeparator(second)) {
                startIndex += 2;
                continue;
            }
            if (second != '.') break;
            if (startIndex + 2 == path.length()) {
                startIndex += 2;
                continue;
            }
            if (!PathKt.isPathSeparator(path.charAt(startIndex + 2))) break;
            startIndex += 3;
        }
        return startIndex;
    }

    private static final boolean isPathSeparator(char $this$isPathSeparator) {
        return $this$isPathSeparator == '\\' || $this$isPathSeparator == '/';
    }

    private static final boolean isPathSeparatorOrDot(char $this$isPathSeparatorOrDot) {
        return $this$isPathSeparatorOrDot == '.' || PathKt.isPathSeparator($this$isPathSeparatorOrDot);
    }

    private static final File dropLeadingTopDirs(File $this$dropLeadingTopDirs) {
        String string = $this$dropLeadingTopDirs.getPath();
        int startIndex = PathKt.dropLeadingTopDirs(string == null ? "" : string);
        if (startIndex == 0) {
            return $this$dropLeadingTopDirs;
        }
        if (startIndex >= $this$dropLeadingTopDirs.getPath().length()) {
            return new File(".");
        }
        string = $this$dropLeadingTopDirs.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
        boolean bl = false;
        String string2 = string.substring(startIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        return new File(string2);
    }
}

