/*
 * Decompiled with CFR 0.152.
 */
package io.lsn.aspose.cells.helper;

import com.aspose.cells.Cell;
import com.aspose.cells.Cells;
import com.aspose.cells.Row;
import com.aspose.cells.Style;
import com.aspose.cells.StyleFlag;
import com.aspose.cells.Worksheet;
import io.lsn.aspose.cells.helper.AsposeCellsHelper;
import io.lsn.aspose.cells.helper.annotation.CellsData;
import io.lsn.aspose.cells.helper.converter.AbstractAsposeConverter;
import io.lsn.spring.utilities.generic.GetValueInterface;
import io.lsn.spring.utilities.helper.DateHelper;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.ReflectionUtils;

@Service
public class AsposeCellsService {
    private static final int DATE_FORMAT = 14;
    private StyleFlag numberStyleFlag = new StyleFlag();
    private GetValueInterface translationService;
    private boolean autoTrim = true;

    public AsposeCellsService() {
        this.numberStyleFlag.setNumberFormat(true);
        AsposeCellsHelper.setService(this);
    }

    @Autowired(required=false)
    public void setTranslationService(@Qualifier(value="translationService") GetValueInterface translationService) {
        this.translationService = translationService;
    }

    public boolean isAutoTrim() {
        return this.autoTrim;
    }

    public AsposeCellsService setAutoTrim(boolean autoTrim) {
        this.autoTrim = autoTrim;
        return this;
    }

    private Object getValue(Row row, int columnIndex, String classCanonicalName, CellsData cellsData) {
        Cell c = row.getCellOrNull(columnIndex);
        if (c == null) {
            return null;
        }
        if (!cellsData.converter().equals(AbstractAsposeConverter.class)) {
            try {
                Object o = Class.forName(cellsData.converter().getName()).getConstructor(new Class[0]).newInstance(new Object[0]);
                return ((AbstractAsposeConverter)o).valueOf(c.getStringValue() != null && this.isAutoTrim() ? c.getStringValue().trim() : c.getStringValue(), cellsData);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (classCanonicalName.equals(String.class.getCanonicalName())) {
            if (this.isAutoTrim()) {
                return c.getStringValue() != null ? c.getStringValue().trim() : null;
            }
            return c.getStringValue();
        }
        if (classCanonicalName.equals(Long.class.getCanonicalName())) {
            return (long)c.getIntValue();
        }
        if (classCanonicalName.equals(BigDecimal.class.getCanonicalName())) {
            return BigDecimal.valueOf(c.getFloatValue()).setScale(cellsData.scale(), RoundingMode.HALF_UP);
        }
        if (classCanonicalName.equals(Integer.class.getCanonicalName())) {
            return c.getIntValue();
        }
        if (classCanonicalName.equals(LocalDate.class.getCanonicalName())) {
            return Instant.ofEpochMilli(c.getDateTimeValue().toDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
        }
        if (classCanonicalName.equals(LocalDateTime.class.getCanonicalName())) {
            return Instant.ofEpochMilli(c.getDateTimeValue().toDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
        }
        return null;
    }

    public <T> List<T> map(Class<T> targetClass, Worksheet worksheet, boolean skipHeader) {
        Cells cells = worksheet.getCells();
        ArrayList<T> result = new ArrayList<T>();
        for (int i = skipHeader ? 1 : 0; i < cells.getMaxDataRow() + 1; ++i) {
            Row row = cells.getRows().get(i);
            result.add(this.map(targetClass, row));
        }
        return result;
    }

    private <T> T map(Class<T> targetClass, Row row) {
        try {
            Object item = targetClass.newInstance();
            List<Field> fieldList = Arrays.asList(targetClass.getDeclaredFields());
            fieldList.forEach(f -> {
                CellsData d = f.getAnnotation(CellsData.class);
                if (d != null) {
                    ReflectionUtils.makeAccessible((Field)f);
                    try {
                        f.set(item, this.getValue(row, d.columnIndex(), f.getType().getCanonicalName(), d));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            return item;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void write(Worksheet w, Class targetClass, List<?> list, Boolean autofit) {
        this.write(w, targetClass, list);
        if (Boolean.TRUE.equals(autofit)) {
            AsposeCellsService.safeAutoFit(w);
        }
    }

    private void write(Worksheet w, Class targetClass, List<? extends Object> list) {
        Style dateStyle = w.getWorkbook().createStyle();
        dateStyle.setNumber(14);
        dateStyle.setCustom("yyyy-mm-dd");
        Style dateTimeStyle = w.getWorkbook().createStyle();
        dateTimeStyle.setNumber(14);
        dateTimeStyle.setCustom("yyyy-mm-dd HH:mm");
        Arrays.asList(targetClass.getDeclaredFields()).forEach(e -> {
            CellsData a = e.getAnnotation(CellsData.class);
            if (a != null) {
                if (StringUtils.isNotBlank((String)a.columnName())) {
                    w.getCells().get(0, a.columnIndex()).setValue((Object)a.columnName());
                } else if (StringUtils.isNotBlank((String)a.columnTranslationCode())) {
                    String value = this.translationService != null ? this.translationService.getValue(a.columnTranslationCode()) : a.columnTranslationCode();
                    w.getCells().get(0, a.columnIndex()).setValue((Object)value);
                } else {
                    w.getCells().get(0, a.columnIndex()).setValue((Object)e.getName());
                }
                if (e.getGenericType().equals(LocalDate.class)) {
                    w.getCells().getColumns().get(a.columnIndex()).applyStyle(dateStyle, this.numberStyleFlag);
                }
                if (e.getGenericType().equals(LocalDateTime.class)) {
                    w.getCells().getColumns().get(a.columnIndex()).applyStyle(dateTimeStyle, this.numberStyleFlag);
                }
            }
        });
        w.getCells().insertRows(2, list.size());
        for (int i = 0; i < list.size(); ++i) {
            Object h = list.get(i);
            int rowIndex = i + 1;
            Arrays.asList(targetClass.getDeclaredFields()).forEach(e -> {
                CellsData a = e.getAnnotation(CellsData.class);
                if (a != null) {
                    try {
                        ReflectionUtils.makeAccessible((Field)e);
                        w.getCells().get(rowIndex, a.columnIndex()).setValue(e.get(h));
                        if (e.getGenericType().equals(LocalDate.class)) {
                            w.getCells().get(rowIndex, a.columnIndex()).setValue((Object)DateHelper.asDate((LocalDate)((LocalDate)e.get(h))));
                        }
                        if (e.getGenericType().equals(LocalDateTime.class)) {
                            w.getCells().get(rowIndex, a.columnIndex()).setValue((Object)DateHelper.asDate((LocalDateTime)((LocalDateTime)e.get(h))));
                        }
                        if (e.getGenericType().equals(Boolean.class)) {
                            w.getCells().get(rowIndex, a.columnIndex()).setValue((Object)(Boolean.TRUE.equals(e.get(h)) ? "true" : "false"));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    private static void safeAutoFit(Worksheet w) {
        try {
            w.autoFitColumns();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

