/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.lang.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;

public interface LongTaskTimer
extends Meter {
    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static Builder builder(Timed timed) {
        if (!timed.longTask()) {
            throw new IllegalArgumentException("Cannot build a long task timer from a @Timed annotation that is not marked as a long task");
        }
        if (timed.value().isEmpty()) {
            throw new IllegalArgumentException("Long tasks instrumented with @Timed require the value attribute to be non-empty");
        }
        return new Builder(timed.value()).tags(timed.extraTags()).description(timed.description().isEmpty() ? null : timed.description());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> T recordCallable(Callable<T> f) throws Exception {
        Sample sample = this.start();
        try {
            T t = f.call();
            return t;
        }
        finally {
            sample.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> T record(Supplier<T> f) {
        Sample sample = this.start();
        try {
            T t = f.get();
            return t;
        }
        finally {
            sample.stop();
        }
    }

    default public void record(Consumer<Sample> f) {
        Sample sample = this.start();
        try {
            f.accept(sample);
        }
        finally {
            sample.stop();
        }
    }

    default public void record(Runnable f) {
        Sample sample = this.start();
        try {
            f.run();
        }
        finally {
            sample.stop();
        }
    }

    public Sample start();

    public long stop(long var1);

    public double duration(long var1, TimeUnit var3);

    public double duration(TimeUnit var1);

    public int activeTasks();

    @Override
    default public Iterable<Measurement> measure() {
        return Arrays.asList(new Measurement(() -> this.activeTasks(), Statistic.ACTIVE_TASKS), new Measurement(() -> this.duration(TimeUnit.NANOSECONDS), Statistic.DURATION));
    }

    public static class Builder {
        private final String name;
        private final List<Tag> tags = new ArrayList<Tag>();
        @Nullable
        private String description;

        private Builder(String name) {
            this.name = name;
        }

        public Builder tags(String ... tags) {
            return this.tags(Tags.of(tags));
        }

        public Builder tags(Iterable<Tag> tags) {
            tags.forEach(this.tags::add);
            return this;
        }

        public Builder tag(String key, String value) {
            this.tags.add(Tag.of(key, value));
            return this;
        }

        public Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public LongTaskTimer register(MeterRegistry registry) {
            return registry.more().longTaskTimer(new Meter.Id(this.name, this.tags, null, this.description, Meter.Type.LONG_TASK_TIMER));
        }
    }

    public static class Sample {
        private final LongTaskTimer timer;
        private final long task;

        public Sample(LongTaskTimer timer, long task) {
            this.timer = timer;
            this.task = task;
        }

        public long stop() {
            return this.timer.stop(this.task);
        }

        public double duration(TimeUnit unit) {
            return this.timer.duration(this.task, unit);
        }
    }
}

