/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.mongodb;

import com.mongodb.connection.ServerId;
import com.mongodb.event.ConnectionAddedEvent;
import com.mongodb.event.ConnectionCheckedInEvent;
import com.mongodb.event.ConnectionCheckedOutEvent;
import com.mongodb.event.ConnectionPoolClosedEvent;
import com.mongodb.event.ConnectionPoolListenerAdapter;
import com.mongodb.event.ConnectionPoolOpenedEvent;
import com.mongodb.event.ConnectionPoolWaitQueueEnteredEvent;
import com.mongodb.event.ConnectionPoolWaitQueueExitedEvent;
import com.mongodb.event.ConnectionRemovedEvent;
import io.micrometer.core.annotation.Incubating;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.lang.NonNullApi;
import io.micrometer.core.lang.NonNullFields;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

@NonNullApi
@NonNullFields
@Incubating(since="1.2.0")
public class MongoMetricsConnectionPoolListener
extends ConnectionPoolListenerAdapter {
    private static final String METRIC_PREFIX = "mongodb.driver.pool.";
    private final Map<ServerId, AtomicInteger> poolSize = new ConcurrentHashMap<ServerId, AtomicInteger>();
    private final Map<ServerId, AtomicInteger> checkedOutCount = new ConcurrentHashMap<ServerId, AtomicInteger>();
    private final Map<ServerId, AtomicInteger> waitQueueSize = new ConcurrentHashMap<ServerId, AtomicInteger>();
    private final Map<ServerId, List<Meter>> meters = new ConcurrentHashMap<ServerId, List<Meter>>();
    private final MeterRegistry registry;

    public MongoMetricsConnectionPoolListener(MeterRegistry registry) {
        this.registry = registry;
    }

    public void connectionPoolOpened(ConnectionPoolOpenedEvent event) {
        ArrayList<Gauge> connectionMeters = new ArrayList<Gauge>();
        connectionMeters.add(this.registerGauge(event.getServerId(), "mongodb.driver.pool.size", "the current size of the connection pool, including idle and and in-use members", this.poolSize));
        connectionMeters.add(this.registerGauge(event.getServerId(), "mongodb.driver.pool.checkedout", "the count of connections that are currently in use", this.checkedOutCount));
        connectionMeters.add(this.registerGauge(event.getServerId(), "mongodb.driver.pool.waitqueuesize", "the current size of the wait queue for a connection from the pool", this.waitQueueSize));
        this.meters.put(event.getServerId(), connectionMeters);
    }

    public void connectionPoolClosed(ConnectionPoolClosedEvent event) {
        ServerId serverId = event.getServerId();
        for (Meter meter : this.meters.get(event.getServerId())) {
            this.registry.remove(meter);
        }
        this.meters.remove(serverId);
        this.poolSize.remove(serverId);
        this.checkedOutCount.remove(serverId);
        this.waitQueueSize.remove(serverId);
    }

    public void connectionCheckedOut(ConnectionCheckedOutEvent event) {
        this.checkedOutCount.get(event.getConnectionId().getServerId()).incrementAndGet();
    }

    public void connectionCheckedIn(ConnectionCheckedInEvent event) {
        this.checkedOutCount.get(event.getConnectionId().getServerId()).decrementAndGet();
    }

    public void waitQueueEntered(ConnectionPoolWaitQueueEnteredEvent event) {
        this.waitQueueSize.get(event.getServerId()).incrementAndGet();
    }

    public void waitQueueExited(ConnectionPoolWaitQueueExitedEvent event) {
        this.waitQueueSize.get(event.getServerId()).decrementAndGet();
    }

    public void connectionAdded(ConnectionAddedEvent event) {
        this.poolSize.get(event.getConnectionId().getServerId()).incrementAndGet();
    }

    public void connectionRemoved(ConnectionRemovedEvent event) {
        this.poolSize.get(event.getConnectionId().getServerId()).decrementAndGet();
    }

    private Gauge registerGauge(ServerId serverId, String metricName, String description, Map<ServerId, AtomicInteger> metrics) {
        metrics.put(serverId, new AtomicInteger());
        return Gauge.builder(metricName, metrics, m -> ((AtomicInteger)m.get(serverId)).doubleValue()).description(description).tag("cluster.id", serverId.getClusterId().getValue()).tag("server.address", serverId.getAddress().toString()).register(this.registry);
    }
}

