/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.cache;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

class HazelcastIMapAdapter {
    private static final MethodHandle GET_NAME = HazelcastIMapAdapter.resolveIMapMethod("getName", MethodType.methodType(String.class));
    private static final MethodHandle GET_LOCAL_MAP_STATS = HazelcastIMapAdapter.resolveIMapMethod("getLocalMapStats", MethodType.methodType(HazelcastIMapAdapter.resolveLocalMapStatsImplementation()));
    private Object cache;

    HazelcastIMapAdapter(Object cache) {
        this.cache = cache;
    }

    static String nameOf(Object cache) {
        try {
            return GET_NAME.invoke(cache);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    LocalMapStats getLocalMapStats() {
        Object result = HazelcastIMapAdapter.invoke(GET_LOCAL_MAP_STATS, this.cache);
        return result == null ? null : new LocalMapStats(result);
    }

    private static MethodHandle resolveIMapMethod(String name, MethodType mt) {
        try {
            return MethodHandles.publicLookup().findVirtual(HazelcastIMapAdapter.resolveIMapImplementation(), name, mt);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Class<?> resolveIMapImplementation() {
        return HazelcastIMapAdapter.resolveOneOf("com.hazelcast.map.IMap", "com.hazelcast.core.IMap");
    }

    private static Class<?> resolveLocalMapStatsImplementation() {
        return HazelcastIMapAdapter.resolveOneOf("com.hazelcast.map.LocalMapStats", "com.hazelcast.monitor.LocalMapStats");
    }

    private static Class<?> resolveNearCacheStatsImplementation() {
        return HazelcastIMapAdapter.resolveOneOf("com.hazelcast.nearcache.NearCacheStats", "com.hazelcast.monitor.NearCacheStats");
    }

    private static Class<?> resolveOneOf(String class1, String class2) {
        try {
            return Class.forName(class1);
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(class2);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private static Object invoke(MethodHandle mh, Object object) {
        try {
            return mh.invoke(object);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    static class LocalMapStats {
        private static final MethodHandle GET_NEAR_CACHE_STATS = LocalMapStats.resolveLocalMapStatsMethod("getNearCacheStats", MethodType.methodType(HazelcastIMapAdapter.access$000()));
        private static final MethodHandle GET_OWNED_ENTRY_COUNT = LocalMapStats.resolveLocalMapStatsMethod("getOwnedEntryCount", MethodType.methodType(Long.TYPE));
        private static final MethodHandle GET_HITS = LocalMapStats.resolveLocalMapStatsMethod("getHits", MethodType.methodType(Long.TYPE));
        private static final MethodHandle GET_PUT_OPERATION_COUNT = LocalMapStats.resolveLocalMapStatsMethod("getPutOperationCount", MethodType.methodType(Long.TYPE));
        private static final MethodHandle GET_BACKUP_ENTRY_COUNT = LocalMapStats.resolveLocalMapStatsMethod("getBackupEntryCount", MethodType.methodType(Long.TYPE));
        private static final MethodHandle GET_BACKUP_ENTRY_MEMORY_COST = LocalMapStats.resolveLocalMapStatsMethod("getBackupEntryMemoryCost", MethodType.methodType(Long.TYPE));
        private static final MethodHandle GET_OWNED_ENTRY_MEMORY_COST = LocalMapStats.resolveLocalMapStatsMethod("getOwnedEntryMemoryCost", MethodType.methodType(Long.TYPE));
        private static final MethodHandle GET_GET_OPERATION_COUNT = LocalMapStats.resolveLocalMapStatsMethod("getGetOperationCount", MethodType.methodType(Long.TYPE));
        private static final MethodHandle GET_TOTAL_GET_LATENCY = LocalMapStats.resolveLocalMapStatsMethod("getTotalGetLatency", MethodType.methodType(Long.TYPE));
        private static final MethodHandle GET_TOTAL_PUT_LATENCY = LocalMapStats.resolveLocalMapStatsMethod("getTotalPutLatency", MethodType.methodType(Long.TYPE));
        private static final MethodHandle GET_REMOVE_OPERATION_COUNT = LocalMapStats.resolveLocalMapStatsMethod("getRemoveOperationCount", MethodType.methodType(Long.TYPE));
        private static final MethodHandle GET_TOTAL_REMOVE_LATENCY = LocalMapStats.resolveLocalMapStatsMethod("getTotalRemoveLatency", MethodType.methodType(Long.TYPE));
        private Object localMapStats;

        LocalMapStats(Object localMapStats) {
            this.localMapStats = localMapStats;
        }

        long getOwnedEntryCount() {
            return (Long)HazelcastIMapAdapter.invoke(LocalMapStats.GET_OWNED_ENTRY_COUNT, this.localMapStats);
        }

        long getHits() {
            return (Long)HazelcastIMapAdapter.invoke(LocalMapStats.GET_HITS, this.localMapStats);
        }

        long getPutOperationCount() {
            return (Long)HazelcastIMapAdapter.invoke(LocalMapStats.GET_PUT_OPERATION_COUNT, this.localMapStats);
        }

        double getBackupEntryCount() {
            return ((Long)HazelcastIMapAdapter.invoke(LocalMapStats.GET_BACKUP_ENTRY_COUNT, this.localMapStats)).longValue();
        }

        long getBackupEntryMemoryCost() {
            return (Long)HazelcastIMapAdapter.invoke(LocalMapStats.GET_BACKUP_ENTRY_MEMORY_COST, this.localMapStats);
        }

        long getOwnedEntryMemoryCost() {
            return (Long)HazelcastIMapAdapter.invoke(LocalMapStats.GET_OWNED_ENTRY_MEMORY_COST, this.localMapStats);
        }

        long getGetOperationCount() {
            return (Long)HazelcastIMapAdapter.invoke(LocalMapStats.GET_GET_OPERATION_COUNT, this.localMapStats);
        }

        NearCacheStats getNearCacheStats() {
            Object result = HazelcastIMapAdapter.invoke(LocalMapStats.GET_NEAR_CACHE_STATS, this.localMapStats);
            return result == null ? null : new NearCacheStats(result);
        }

        long getTotalGetLatency() {
            return (Long)HazelcastIMapAdapter.invoke(LocalMapStats.GET_TOTAL_GET_LATENCY, this.localMapStats);
        }

        long getTotalPutLatency() {
            return (Long)HazelcastIMapAdapter.invoke(LocalMapStats.GET_TOTAL_PUT_LATENCY, this.localMapStats);
        }

        long getRemoveOperationCount() {
            return (Long)HazelcastIMapAdapter.invoke(LocalMapStats.GET_REMOVE_OPERATION_COUNT, this.localMapStats);
        }

        long getTotalRemoveLatency() {
            return (Long)HazelcastIMapAdapter.invoke(LocalMapStats.GET_TOTAL_REMOVE_LATENCY, this.localMapStats);
        }

        private static MethodHandle resolveLocalMapStatsMethod(String name, MethodType mt) {
            try {
                return MethodHandles.publicLookup().findVirtual(HazelcastIMapAdapter.resolveLocalMapStatsImplementation(), name, mt);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    static class NearCacheStats {
        private static final MethodHandle GET_HITS = NearCacheStats.resolveNearCacheStatsMethod("getHits", MethodType.methodType(Long.TYPE));
        private static final MethodHandle GET_MISSES = NearCacheStats.resolveNearCacheStatsMethod("getMisses", MethodType.methodType(Long.TYPE));
        private static final MethodHandle GET_EVICTIONS = NearCacheStats.resolveNearCacheStatsMethod("getEvictions", MethodType.methodType(Long.TYPE));
        private static final MethodHandle GET_PERSISTENCE_COUNT = NearCacheStats.resolveNearCacheStatsMethod("getPersistenceCount", MethodType.methodType(Long.TYPE));
        private Object nearCacheStats;

        NearCacheStats(Object nearCacheStats) {
            this.nearCacheStats = nearCacheStats;
        }

        long getHits() {
            return (Long)HazelcastIMapAdapter.invoke(NearCacheStats.GET_HITS, this.nearCacheStats);
        }

        long getMisses() {
            return (Long)HazelcastIMapAdapter.invoke(NearCacheStats.GET_MISSES, this.nearCacheStats);
        }

        long getEvictions() {
            return (Long)HazelcastIMapAdapter.invoke(NearCacheStats.GET_EVICTIONS, this.nearCacheStats);
        }

        long getPersistenceCount() {
            return (Long)HazelcastIMapAdapter.invoke(NearCacheStats.GET_PERSISTENCE_COUNT, this.nearCacheStats);
        }

        private static MethodHandle resolveNearCacheStatsMethod(String name, MethodType mt) {
            try {
                return MethodHandles.publicLookup().findVirtual(HazelcastIMapAdapter.resolveNearCacheStatsImplementation(), name, mt);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

