/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.jetty;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import javax.net.ssl.SSLSession;
import org.eclipse.jetty.io.ssl.SslHandshakeListener;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;

public class JettySslHandshakeMetrics
implements SslHandshakeListener {
    private final MeterRegistry registry;
    private final Iterable<Tag> tags;
    private final Counter handshakesFailed;

    public JettySslHandshakeMetrics(MeterRegistry registry) {
        this(registry, Tags.empty());
    }

    public JettySslHandshakeMetrics(MeterRegistry registry, Iterable<Tag> tags) {
        this.registry = registry;
        this.tags = tags;
        this.handshakesFailed = Counter.builder("jetty.ssl.handshakes").baseUnit("events").description("SSL/TLS handshakes").tags(Tags.concat(tags, "result", "failed")).register(registry);
    }

    public void handshakeSucceeded(SslHandshakeListener.Event event) {
        SSLSession session = event.getSSLEngine().getSession();
        Counter.builder("jetty.ssl.handshakes").baseUnit("events").description("SSL/TLS handshakes").tag("result", "succeeded").tag("protocol", session.getProtocol()).tag("ciphersuite", session.getCipherSuite()).tags(this.tags).register(this.registry).increment();
    }

    public void handshakeFailed(SslHandshakeListener.Event event, Throwable failure) {
        this.handshakesFailed.increment();
    }

    public static void addToAllConnectors(Server server, MeterRegistry registry, Iterable<Tag> tags) {
        for (Connector connector : server.getConnectors()) {
            if (connector == null) continue;
            connector.addBean((Object)new JettySslHandshakeMetrics(registry, tags));
        }
    }

    public static void addToAllConnectors(Server server, MeterRegistry registry) {
        JettySslHandshakeMetrics.addToAllConnectors(server, registry, Tags.empty());
    }
}

