/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.okhttp3;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.lang.NonNullApi;
import io.micrometer.core.lang.NonNullFields;
import io.micrometer.core.lang.Nullable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.Request;
import okhttp3.Response;

@NonNullApi
@NonNullFields
public class OkHttpMetricsEventListener
extends EventListener {
    public static final String URI_PATTERN = "URI_PATTERN";
    private static final boolean REQUEST_TAG_CLASS_EXISTS = OkHttpMetricsEventListener.getMethod("tag", Class.class) != null;
    private final MeterRegistry registry;
    private final String requestsMetricName;
    private final Function<Request, String> urlMapper;
    private final Iterable<Tag> extraTags;
    private final Iterable<BiFunction<Request, Response, Tag>> contextSpecificTags;
    private final boolean includeHostTag;
    final ConcurrentMap<Call, CallState> callState = new ConcurrentHashMap<Call, CallState>();

    private static Method getMethod(String name, Class<?> ... parameterTypes) {
        try {
            return Request.class.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    protected OkHttpMetricsEventListener(MeterRegistry registry, String requestsMetricName, Function<Request, String> urlMapper, Iterable<Tag> extraTags, Iterable<BiFunction<Request, Response, Tag>> contextSpecificTags) {
        this(registry, requestsMetricName, urlMapper, extraTags, contextSpecificTags, true);
    }

    OkHttpMetricsEventListener(MeterRegistry registry, String requestsMetricName, Function<Request, String> urlMapper, Iterable<Tag> extraTags, Iterable<BiFunction<Request, Response, Tag>> contextSpecificTags, boolean includeHostTag) {
        this.registry = registry;
        this.requestsMetricName = requestsMetricName;
        this.urlMapper = urlMapper;
        this.extraTags = extraTags;
        this.contextSpecificTags = contextSpecificTags;
        this.includeHostTag = includeHostTag;
    }

    public static Builder builder(MeterRegistry registry, String name) {
        return new Builder(registry, name);
    }

    public void callStart(Call call) {
        this.callState.put(call, new CallState(this.registry.config().clock().monotonicTime(), call.request()));
    }

    public void callFailed(Call call, IOException e) {
        CallState state = (CallState)this.callState.remove(call);
        if (state != null) {
            state.exception = e;
            this.time(state);
        }
    }

    public void callEnd(Call call) {
        this.callState.remove(call);
    }

    public void responseHeadersEnd(Call call, Response response) {
        CallState state = (CallState)this.callState.remove(call);
        if (state != null) {
            state.response = response;
            this.time(state);
        }
    }

    private void time(CallState state) {
        Request request = state.request;
        boolean requestAvailable = request != null;
        String uri = state.response != null && (state.response.code() == 404 || state.response.code() == 301) ? "NOT_FOUND" : this.urlMapper.apply(request);
        Tags requestTags = requestAvailable ? this.getRequestTags(request).and(this.generateTagsForRoute(request)) : Tags.empty();
        Tags tags = Tags.of("method", requestAvailable ? request.method() : "UNKNOWN", "uri", requestAvailable ? uri : "UNKNOWN", "status", this.getStatusMessage(state.response, state.exception)).and(this.extraTags).and(StreamSupport.stream(this.contextSpecificTags.spliterator(), false).map(contextTag -> (Tag)contextTag.apply(request, state.response)).collect(Collectors.toList())).and(requestTags);
        tags = this.includeHostTag ? Tags.of(tags).and("host", requestAvailable ? request.url().host() : "UNKNOWN") : tags;
        Timer.builder(this.requestsMetricName).tags(tags).description("Timer of OkHttp operation").register(this.registry).record(this.registry.config().clock().monotonicTime() - state.startTime, TimeUnit.NANOSECONDS);
    }

    private Tags generateTagsForRoute(Request request) {
        return Tags.of("target.scheme", request.url().scheme(), "target.host", request.url().host(), "target.port", Integer.toString(request.url().port()));
    }

    private Tags getRequestTags(Request request) {
        Object requestTag;
        if (REQUEST_TAG_CLASS_EXISTS && (requestTag = (Tags)request.tag(Tags.class)) != null) {
            return requestTag;
        }
        requestTag = request.tag();
        if (requestTag instanceof Tags) {
            return (Tags)requestTag;
        }
        return Tags.empty();
    }

    private String getStatusMessage(@Nullable Response response, @Nullable IOException exception) {
        if (exception != null) {
            return "IO_ERROR";
        }
        if (response == null) {
            return "CLIENT_ERROR";
        }
        return Integer.toString(response.code());
    }

    public static class Builder {
        private final MeterRegistry registry;
        private final String name;
        private Function<Request, String> uriMapper = request -> Optional.ofNullable(request.header(OkHttpMetricsEventListener.URI_PATTERN)).orElse("none");
        private Tags tags = Tags.empty();
        private Collection<BiFunction<Request, Response, Tag>> contextSpecificTags = new ArrayList<BiFunction<Request, Response, Tag>>();
        private boolean includeHostTag = true;

        Builder(MeterRegistry registry, String name) {
            this.registry = registry;
            this.name = name;
        }

        public Builder tags(Iterable<Tag> tags) {
            this.tags = this.tags.and(tags);
            return this;
        }

        public Builder tag(Tag tag) {
            this.tags = this.tags.and(tag);
            return this;
        }

        public Builder tag(BiFunction<Request, Response, Tag> contextSpecificTag) {
            this.contextSpecificTags.add(contextSpecificTag);
            return this;
        }

        public Builder uriMapper(Function<Request, String> uriMapper) {
            this.uriMapper = uriMapper;
            return this;
        }

        public Builder includeHostTag(boolean includeHostTag) {
            this.includeHostTag = includeHostTag;
            return this;
        }

        public OkHttpMetricsEventListener build() {
            return new OkHttpMetricsEventListener(this.registry, this.name, this.uriMapper, this.tags, this.contextSpecificTags, this.includeHostTag);
        }
    }

    private static class CallState {
        final long startTime;
        @Nullable
        final Request request;
        @Nullable
        Response response;
        @Nullable
        IOException exception;

        CallState(long startTime, @Nullable Request request) {
            this.startTime = startTime;
            this.request = request;
        }
    }
}

