/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.cloudwatch2;

import io.micrometer.cloudwatch2.CloudWatchConfig;
import io.micrometer.cloudwatch2.CloudWatchNamingConvention;
import io.micrometer.cloudwatch2.CloudWatchUtils;
import io.micrometer.cloudwatch2.MetricDatumPartition;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import io.micrometer.core.instrument.util.StringUtils;
import io.micrometer.core.lang.Nullable;
import io.micrometer.core.util.internal.logging.WarnThenDebugLogger;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.exception.AbortedException;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.MetricDatum;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;

public class CloudWatchMeterRegistry
extends StepMeterRegistry {
    private static final Map<String, StandardUnit> STANDARD_UNIT_BY_LOWERCASE_VALUE;
    private final CloudWatchConfig config;
    private final CloudWatchAsyncClient cloudWatchAsyncClient;
    private final Logger logger = LoggerFactory.getLogger(CloudWatchMeterRegistry.class);
    private static final WarnThenDebugLogger warnThenDebugLogger;

    public CloudWatchMeterRegistry(CloudWatchConfig config, Clock clock, CloudWatchAsyncClient cloudWatchAsyncClient) {
        this(config, clock, cloudWatchAsyncClient, (ThreadFactory)new NamedThreadFactory("cloudwatch-metrics-publisher"));
    }

    public CloudWatchMeterRegistry(CloudWatchConfig config, Clock clock, CloudWatchAsyncClient cloudWatchAsyncClient, ThreadFactory threadFactory) {
        super((StepRegistryConfig)config, clock);
        this.cloudWatchAsyncClient = cloudWatchAsyncClient;
        this.config = config;
        this.config().namingConvention((NamingConvention)new CloudWatchNamingConvention());
        this.start(threadFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publish() {
        boolean interrupted = false;
        try {
            for (List<MetricDatum> batch : MetricDatumPartition.partition(this.metricData(), this.config.batchSize())) {
                try {
                    this.sendMetricData(batch);
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                }
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    void sendMetricData(List<MetricDatum> metricData) throws InterruptedException {
        PutMetricDataRequest putMetricDataRequest = (PutMetricDataRequest)PutMetricDataRequest.builder().namespace(this.config.namespace()).metricData(metricData).build();
        CountDownLatch latch = new CountDownLatch(1);
        this.cloudWatchAsyncClient.putMetricData(putMetricDataRequest).whenCompleteAsync((response, t) -> {
            if (t != null) {
                if (t instanceof AbortedException) {
                    this.logger.warn("sending metric data was aborted: {}", (Object)t.getMessage());
                } else {
                    this.logger.error("error sending metric data.", t);
                }
            } else {
                this.logger.debug("published metric with namespace:{}", (Object)putMetricDataRequest.namespace());
            }
            latch.countDown();
        });
        try {
            long readTimeoutMillis = this.config.readTimeout().toMillis();
            latch.await(readTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.logger.warn("metrics push to cloudwatch took longer than expected");
            throw e;
        }
    }

    List<MetricDatum> metricData() {
        Batch batch = new Batch();
        return this.getMeters().stream().flatMap(m -> (Stream)m.match(x$0 -> batch.gaugeData(x$0), x$0 -> batch.counterData(x$0), batch::timerData, batch::summaryData, x$0 -> batch.longTaskTimerData(x$0), x$0 -> batch.timeGaugeData(x$0), batch::functionCounterData, batch::functionTimerData, batch::metricData)).collect(Collectors.toList());
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    static {
        HashMap<String, StandardUnit> standardUnitByLowercaseValue = new HashMap<String, StandardUnit>();
        for (StandardUnit standardUnit : StandardUnit.values()) {
            if (standardUnit == StandardUnit.UNKNOWN_TO_SDK_VERSION) continue;
            standardUnitByLowercaseValue.put(standardUnit.toString().toLowerCase(), standardUnit);
        }
        STANDARD_UNIT_BY_LOWERCASE_VALUE = Collections.unmodifiableMap(standardUnitByLowercaseValue);
        warnThenDebugLogger = new WarnThenDebugLogger(CloudWatchMeterRegistry.class);
    }

    class Batch {
        private final Instant timestamp;

        Batch() {
            this.timestamp = Instant.ofEpochMilli(CloudWatchMeterRegistry.this.clock.wallTime());
        }

        private Stream<MetricDatum> gaugeData(Gauge gauge) {
            MetricDatum metricDatum = this.metricDatum(gauge.getId(), "value", gauge.value());
            if (metricDatum == null) {
                return Stream.empty();
            }
            return Stream.of(metricDatum);
        }

        private Stream<MetricDatum> counterData(Counter counter) {
            return Stream.of(this.metricDatum(counter.getId(), "count", StandardUnit.COUNT, counter.count()));
        }

        Stream<MetricDatum> timerData(Timer timer) {
            Stream.Builder<MetricDatum> metrics = Stream.builder();
            metrics.add(this.metricDatum(timer.getId(), "sum", CloudWatchMeterRegistry.this.getBaseTimeUnit().name(), timer.totalTime(CloudWatchMeterRegistry.this.getBaseTimeUnit())));
            long count = timer.count();
            metrics.add(this.metricDatum(timer.getId(), "count", StandardUnit.COUNT, (double)count));
            if (count > 0L) {
                metrics.add(this.metricDatum(timer.getId(), "avg", CloudWatchMeterRegistry.this.getBaseTimeUnit().name(), timer.mean(CloudWatchMeterRegistry.this.getBaseTimeUnit())));
                metrics.add(this.metricDatum(timer.getId(), "max", CloudWatchMeterRegistry.this.getBaseTimeUnit().name(), timer.max(CloudWatchMeterRegistry.this.getBaseTimeUnit())));
            }
            return metrics.build();
        }

        Stream<MetricDatum> summaryData(DistributionSummary summary) {
            Stream.Builder<MetricDatum> metrics = Stream.builder();
            metrics.add(this.metricDatum(summary.getId(), "sum", summary.totalAmount()));
            long count = summary.count();
            metrics.add(this.metricDatum(summary.getId(), "count", StandardUnit.COUNT, (double)count));
            if (count > 0L) {
                metrics.add(this.metricDatum(summary.getId(), "avg", summary.mean()));
                metrics.add(this.metricDatum(summary.getId(), "max", summary.max()));
            }
            return metrics.build();
        }

        private Stream<MetricDatum> longTaskTimerData(LongTaskTimer longTaskTimer) {
            return Stream.of(this.metricDatum(longTaskTimer.getId(), "activeTasks", longTaskTimer.activeTasks()), this.metricDatum(longTaskTimer.getId(), "duration", longTaskTimer.duration(CloudWatchMeterRegistry.this.getBaseTimeUnit())));
        }

        private Stream<MetricDatum> timeGaugeData(TimeGauge gauge) {
            MetricDatum metricDatum = this.metricDatum(gauge.getId(), "value", gauge.value(CloudWatchMeterRegistry.this.getBaseTimeUnit()));
            if (metricDatum == null) {
                return Stream.empty();
            }
            return Stream.of(metricDatum);
        }

        Stream<MetricDatum> functionCounterData(FunctionCounter counter) {
            MetricDatum metricDatum = this.metricDatum(counter.getId(), "count", StandardUnit.COUNT, counter.count());
            if (metricDatum == null) {
                return Stream.empty();
            }
            return Stream.of(metricDatum);
        }

        Stream<MetricDatum> functionTimerData(FunctionTimer timer) {
            double sum = timer.totalTime(CloudWatchMeterRegistry.this.getBaseTimeUnit());
            if (!Double.isFinite(sum)) {
                return Stream.empty();
            }
            Stream.Builder<MetricDatum> metrics = Stream.builder();
            double count = timer.count();
            metrics.add(this.metricDatum(timer.getId(), "count", StandardUnit.COUNT, count));
            metrics.add(this.metricDatum(timer.getId(), "sum", sum));
            if (count > 0.0) {
                metrics.add(this.metricDatum(timer.getId(), "avg", timer.mean(CloudWatchMeterRegistry.this.getBaseTimeUnit())));
            }
            return metrics.build();
        }

        Stream<MetricDatum> metricData(Meter m) {
            return StreamSupport.stream(m.measure().spliterator(), false).map(ms -> this.metricDatum(m.getId().withTag(ms.getStatistic()), ms.getValue())).filter(Objects::nonNull);
        }

        @Nullable
        private MetricDatum metricDatum(Meter.Id id, double value) {
            return this.metricDatum(id, null, id.getBaseUnit(), value);
        }

        @Nullable
        private MetricDatum metricDatum(Meter.Id id, @Nullable String suffix, double value) {
            return this.metricDatum(id, suffix, id.getBaseUnit(), value);
        }

        @Nullable
        private MetricDatum metricDatum(Meter.Id id, @Nullable String suffix, @Nullable String unit, double value) {
            return this.metricDatum(id, suffix, this.toStandardUnit(unit), value);
        }

        @Nullable
        private MetricDatum metricDatum(Meter.Id id, @Nullable String suffix, StandardUnit standardUnit, double value) {
            if (Double.isNaN(value)) {
                return null;
            }
            List tags = id.getConventionTags(CloudWatchMeterRegistry.this.config().namingConvention());
            return (MetricDatum)MetricDatum.builder().metricName(this.getMetricName(id, suffix)).dimensions(this.toDimensions(tags)).timestamp(this.timestamp).value(Double.valueOf(CloudWatchUtils.clampMetricValue(value))).unit(standardUnit).build();
        }

        String getMetricName(Meter.Id id, @Nullable String suffix) {
            String name = suffix != null ? id.getName() + "." + suffix : id.getName();
            return CloudWatchMeterRegistry.this.config().namingConvention().name(name, id.getType(), id.getBaseUnit());
        }

        StandardUnit toStandardUnit(@Nullable String unit) {
            if (unit == null) {
                return StandardUnit.NONE;
            }
            StandardUnit standardUnit = (StandardUnit)STANDARD_UNIT_BY_LOWERCASE_VALUE.get(unit.toLowerCase());
            return standardUnit != null ? standardUnit : StandardUnit.NONE;
        }

        private List<Dimension> toDimensions(List<Tag> tags) {
            return tags.stream().filter(this::isAcceptableTag).map(tag -> (Dimension)Dimension.builder().name(tag.getKey()).value(tag.getValue()).build()).collect(Collectors.toList());
        }

        private boolean isAcceptableTag(Tag tag) {
            if (StringUtils.isBlank((String)tag.getValue())) {
                warnThenDebugLogger.log("Dropping a tag with key '" + tag.getKey() + "' because its value is blank.");
                return false;
            }
            return true;
        }
    }
}

