/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.health;

import io.micrometer.common.lang.Nullable;
import io.micrometer.core.annotation.Incubating;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.config.MeterFilterReply;
import io.micrometer.core.instrument.simple.CountingMode;
import io.micrometer.core.instrument.simple.SimpleConfig;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import io.micrometer.health.HealthConfig;
import io.micrometer.health.ServiceLevelObjective;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@Incubating(since="1.6.0")
public class HealthMeterRegistry
extends SimpleMeterRegistry {
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new NamedThreadFactory("health-metrics-ticker");
    private final HealthConfig config;
    private final Collection<ServiceLevelObjective> serviceLevelObjectives;
    private final Collection<MeterFilter> serviceLevelObjectiveFilters;
    @Nullable
    private ScheduledExecutorService scheduledExecutorService;

    protected HealthMeterRegistry(final HealthConfig config, Collection<ServiceLevelObjective> serviceLevelObjectives, Collection<MeterFilter> serviceLevelObjectiveFilters, Clock clock, ThreadFactory threadFactory) {
        super(new SimpleConfig(){

            public String get(String key) {
                return null;
            }

            public Duration step() {
                return config.step();
            }

            public final CountingMode mode() {
                return CountingMode.STEP;
            }
        }, clock);
        config.requireValid();
        this.config = config;
        this.serviceLevelObjectives = serviceLevelObjectives;
        this.serviceLevelObjectiveFilters = serviceLevelObjectiveFilters;
        for (ServiceLevelObjective slo : serviceLevelObjectives) {
            for (MeterFilter filter : slo.getAcceptFilters()) {
                this.config().meterFilter(filter);
            }
        }
        this.config().meterFilter(MeterFilter.deny());
        for (ServiceLevelObjective slo : serviceLevelObjectives) {
            for (MeterBinder require : slo.getRequires()) {
                require.bindTo((MeterRegistry)this);
            }
        }
        this.start(threadFactory);
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.NANOSECONDS;
    }

    public static Builder builder(HealthConfig config) {
        return new Builder(config);
    }

    void tick() {
        this.serviceLevelObjectives.forEach(slo -> slo.tick((MeterRegistry)this));
    }

    public Collection<ServiceLevelObjective> getServiceLevelObjectives() {
        return this.serviceLevelObjectives.stream().filter(slo -> this.accept(slo.getId())).map(slo -> this.serviceLevelObjectiveFilters.stream().reduce(slo, (filtered, filter) -> new ServiceLevelObjective.FilteredServiceLevelObjective(filter.map(filtered.getId()), (ServiceLevelObjective)filtered), (obj1, obj2) -> obj2)).collect(Collectors.toList());
    }

    private boolean accept(Meter.Id id) {
        for (MeterFilter filter : this.serviceLevelObjectiveFilters) {
            MeterFilterReply reply = filter.accept(id);
            if (reply == MeterFilterReply.DENY) {
                return false;
            }
            if (reply != MeterFilterReply.ACCEPT) continue;
            return true;
        }
        return true;
    }

    public void start(ThreadFactory threadFactory) {
        if (this.scheduledExecutorService != null) {
            this.stop();
        }
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this.scheduledExecutorService.scheduleAtFixedRate(this::tick, this.config.step().toMillis(), this.config.step().toMillis(), TimeUnit.MILLISECONDS);
    }

    public void stop() {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
            this.scheduledExecutorService = null;
        }
    }

    public void close() {
        this.stop();
        super.close();
    }

    static /* synthetic */ ThreadFactory access$000() {
        return DEFAULT_THREAD_FACTORY;
    }

    public static class Builder {
        private final HealthConfig config;
        private final Collection<ServiceLevelObjective> serviceLevelObjectives = new ArrayList<ServiceLevelObjective>();
        private final Collection<MeterFilter> serviceLevelObjectiveFilters = new ArrayList<MeterFilter>();
        private Clock clock = Clock.SYSTEM;
        private ThreadFactory threadFactory = HealthMeterRegistry.access$000();

        Builder(HealthConfig config) {
            this.config = config;
        }

        public Builder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder serviceLevelObjectives(ServiceLevelObjective ... slos) {
            Collections.addAll(this.serviceLevelObjectives, slos);
            return this;
        }

        public Builder serviceLevelObjectiveFilter(MeterFilter filter) {
            this.serviceLevelObjectiveFilters.add(filter);
            return this;
        }

        public HealthMeterRegistry build() {
            return new HealthMeterRegistry(this.config, this.serviceLevelObjectives, this.serviceLevelObjectiveFilters, this.clock, this.threadFactory);
        }
    }
}

