/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.async;

import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.lang.NonNullApi;
import io.micrometer.core.lang.NonNullFields;
import io.micrometer.core.lang.Nullable;
import io.micrometer.spring.async.TimedThreadPoolTaskExecutor;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@NonNullApi
@NonNullFields
public class ThreadPoolTaskExecutorMetrics
implements MeterBinder {
    private final String name;
    private final Iterable<Tag> tags;
    @Nullable
    private final ThreadPoolTaskExecutor executor;

    public ThreadPoolTaskExecutorMetrics(ThreadPoolTaskExecutor executor, String name, Iterable<Tag> tags) {
        this.name = name;
        this.tags = tags;
        this.executor = executor;
    }

    public static ThreadPoolTaskExecutor monitor(MeterRegistry registry, String name, Iterable<Tag> tags) {
        return new TimedThreadPoolTaskExecutor(registry, name, tags);
    }

    public static Executor monitor(MeterRegistry registry, String name, Tag ... tags) {
        return ThreadPoolTaskExecutorMetrics.monitor(registry, name, Arrays.asList(tags));
    }

    public void bindTo(MeterRegistry registry) {
        if (this.executor == null) {
            return;
        }
        this.monitor(registry, this.executor.getThreadPoolExecutor());
    }

    private void monitor(MeterRegistry registry, ThreadPoolExecutor tp) {
        FunctionCounter.builder((String)(this.name + ".completed"), (Object)tp, ThreadPoolExecutor::getCompletedTaskCount).tags(this.tags).description("The approximate total number of tasks that have completed execution").register(registry);
        Gauge.builder((String)(this.name + ".active"), (Object)tp, ThreadPoolExecutor::getActiveCount).tags(this.tags).description("The approximate number of threads that are actively executing tasks").register(registry);
        Gauge.builder((String)(this.name + ".queued"), (Object)tp, tpRef -> tpRef.getQueue().size()).tags(this.tags).description("The approximate number of threads that are queued for execution").register(registry);
        Gauge.builder((String)(this.name + ".pool"), (Object)tp, ThreadPoolExecutor::getPoolSize).tags(this.tags).description("The current number of threads in the pool").register(registry);
    }
}

