/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.export.wavefront;

import io.micrometer.core.instrument.Clock;
import io.micrometer.spring.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import io.micrometer.spring.autoconfigure.MetricsAutoConfiguration;
import io.micrometer.spring.autoconfigure.export.StringToDurationConverter;
import io.micrometer.spring.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration;
import io.micrometer.spring.autoconfigure.export.wavefront.WavefrontProperties;
import io.micrometer.spring.autoconfigure.export.wavefront.WavefrontPropertiesConfigAdapter;
import io.micrometer.wavefront.WavefrontConfig;
import io.micrometer.wavefront.WavefrontMeterRegistry;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@AutoConfigureBefore(value={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={WavefrontMeterRegistry.class})
@ConditionalOnProperty(prefix="management.metrics.export.wavefront", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={WavefrontProperties.class})
@Import(value={StringToDurationConverter.class})
public class WavefrontMetricsExportAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={WavefrontConfig.class})
    public WavefrontConfig wavefrontConfig(WavefrontProperties props) {
        return new WavefrontPropertiesConfigAdapter(props);
    }

    @Bean
    @ConditionalOnMissingBean
    public WavefrontMeterRegistry wavefrontMeterRegistry(WavefrontConfig config, Clock clock) {
        return new WavefrontMeterRegistry(config, clock);
    }

    @Bean
    @ConditionalOnMissingBean
    public Clock micrometerClock() {
        return Clock.SYSTEM;
    }
}

