/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.kafka.consumer;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.kafka.KafkaConsumerMetrics;
import io.micrometer.spring.autoconfigure.MetricsAutoConfiguration;
import java.util.Collections;
import javax.management.MBeanServer;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={MetricsAutoConfiguration.class, JmxAutoConfiguration.class})
@ConditionalOnClass(value={KafkaConsumerMetrics.class})
@ConditionalOnBean(value={MeterRegistry.class})
public class KafkaMetricsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={MBeanServer.class})
    @ConditionalOnProperty(value={"management.metrics.kafka.consumer.enabled"}, matchIfMissing=true)
    public KafkaConsumerMetrics kafkaConsumerMetrics(MBeanServer mbeanServer) {
        return new KafkaConsumerMetrics(mbeanServer, Collections.emptyList());
    }
}

