/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.ipc.http;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import io.micrometer.core.ipc.http.HttpClientResolver;
import io.micrometer.core.ipc.http.HttpSender;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import ru.lanwen.wiremock.ext.WiremockResolver;

@ExtendWith(value={HttpClientResolver.class, WiremockResolver.class})
public abstract class HttpSenderCompatibilityKit {
    public abstract HttpSender httpClient();

    @Test
    @DisplayName(value="compatibility test provides a non-null http client instance")
    void httpClientIsNotNull(HttpSender httpClient) {
        Assertions.assertThat((Object)httpClient).isNotNull();
    }

    @Test
    void successfulPostWithBody(HttpSender httpClient, @WiremockResolver.Wiremock WireMockServer server) throws Throwable {
        server.stubFor(WireMock.any((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.aResponse().withBody("a body")));
        Assertions.assertThat((String)httpClient.post(server.baseUrl() + "/api").withPlainText("this is a line").send().body()).isEqualTo((Object)"a body");
        server.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/api")).withRequestBody((ContentPattern)WireMock.equalTo((String)"this is a line")));
    }

    @Test
    void successfulPostNoBody(HttpSender httpClient, @WiremockResolver.Wiremock WireMockServer server) throws Throwable {
        server.stubFor(WireMock.any((UrlPattern)WireMock.anyUrl()));
        Assertions.assertThat((String)httpClient.post(server.baseUrl() + "/api").withPlainText("this is a line").send().body()).isEqualTo((Object)"<no response body>");
        server.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/api")).withRequestBody((ContentPattern)WireMock.equalTo((String)"this is a line")));
    }

    @Test
    void failedPostWithBody(HttpSender httpClient, @WiremockResolver.Wiremock WireMockServer server) throws Throwable {
        server.stubFor(WireMock.any((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.aResponse().withStatus(500).withBody("a body")));
        Assertions.assertThat((String)httpClient.post(server.baseUrl() + "/api").send().body()).isEqualTo((Object)"a body");
    }

    @Test
    void failedPostWithNoBody(HttpSender httpClient, @WiremockResolver.Wiremock WireMockServer server) throws Throwable {
        server.stubFor(WireMock.any((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.aResponse().withStatus(500)));
        Assertions.assertThat((String)httpClient.post(server.baseUrl() + "/api").send().body()).isEqualTo((Object)"<no response body>");
    }

    @Test
    void successfulHead(HttpSender httpClient, @WiremockResolver.Wiremock WireMockServer server) throws Throwable {
        server.stubFor(WireMock.any((UrlPattern)WireMock.anyUrl()));
        Assertions.assertThat((String)httpClient.head(server.baseUrl() + "/api").send().body()).isEqualTo((Object)"<no response body>");
    }

    @Test
    void failedHeadWithNoBody(HttpSender httpClient, @WiremockResolver.Wiremock WireMockServer server) throws Throwable {
        server.stubFor(WireMock.any((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.aResponse().withStatus(500)));
        Assertions.assertThat((String)httpClient.head(server.baseUrl() + "/api").send().body()).isEqualTo((Object)"<no response body>");
    }
}

