/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.tck;

import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.MockClock;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

interface LongTaskTimerTest {
    @Test
    @DisplayName(value="total time is preserved for a single timing")
    default public void record(MeterRegistry registry) {
        LongTaskTimer t = registry.more().longTaskTimer("myTimer", new String[0]);
        LongTaskTimer.Sample sample = t.start();
        MockClock.clock((MeterRegistry)registry).add(10L, TimeUnit.NANOSECONDS);
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((double)10.0, (double)t.duration(TimeUnit.NANOSECONDS)), () -> Assertions.assertEquals((double)0.01, (double)t.duration(TimeUnit.MICROSECONDS)), () -> Assertions.assertEquals((double)10.0, (double)sample.duration(TimeUnit.NANOSECONDS)), () -> Assertions.assertEquals((double)0.01, (double)sample.duration(TimeUnit.MICROSECONDS)), () -> Assertions.assertEquals((int)1, (int)t.activeTasks())});
        MockClock.clock((MeterRegistry)registry).add(10L, TimeUnit.NANOSECONDS);
        sample.stop();
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((double)0.0, (double)t.duration(TimeUnit.NANOSECONDS)), () -> Assertions.assertEquals((double)-1.0, (double)sample.duration(TimeUnit.NANOSECONDS)), () -> Assertions.assertEquals((int)0, (int)t.activeTasks())});
    }
}

