/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.util.internal.logging;

import io.micrometer.core.util.internal.logging.InternalLogger;
import io.micrometer.core.util.internal.logging.InternalLoggerFactory;
import io.micrometer.core.util.internal.logging.MockLogger;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;

public class MockLoggerFactory
extends InternalLoggerFactory {
    private final ConcurrentMap<String, MockLogger> loggers = new ConcurrentHashMap<String, MockLogger>();

    public MockLogger getLogger(Class<?> clazz) {
        return this.getLogger(clazz.getName());
    }

    public MockLogger getLogger(String name) {
        return this.loggers.computeIfAbsent(name, MockLogger::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T injectLogger(Supplier<T> supplier) {
        MockLoggerFactory mockLoggerFactory = this;
        synchronized (mockLoggerFactory) {
            InternalLoggerFactory original = MockLoggerFactory.getDefaultFactory();
            MockLoggerFactory.setDefaultFactory((InternalLoggerFactory)this);
            T object = supplier.get();
            MockLoggerFactory.setDefaultFactory((InternalLoggerFactory)original);
            return object;
        }
    }

    protected InternalLogger newInstance(String name) {
        return this.getLogger(name);
    }
}

