/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.brave.bridge;

import brave.handler.MutableSpan;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.exporter.FinishedSpan;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Map;

public class BraveFinishedSpan
implements FinishedSpan {
    private final MutableSpan mutableSpan;

    public BraveFinishedSpan(MutableSpan mutableSpan) {
        this.mutableSpan = mutableSpan;
    }

    public static FinishedSpan fromBrave(MutableSpan mutableSpan) {
        return new BraveFinishedSpan(mutableSpan);
    }

    public static MutableSpan toBrave(FinishedSpan finishedSpan) {
        return ((BraveFinishedSpan)finishedSpan).mutableSpan;
    }

    public FinishedSpan setName(String name) {
        this.mutableSpan.name(name);
        return this;
    }

    public String getName() {
        return this.mutableSpan.name();
    }

    public Instant getStartTimestamp() {
        return this.microsToInstant(this.mutableSpan.startTimestamp());
    }

    private Instant microsToInstant(long micros) {
        return Instant.EPOCH.plus(micros, ChronoUnit.MICROS);
    }

    public Instant getEndTimestamp() {
        return this.microsToInstant(this.mutableSpan.finishTimestamp());
    }

    public FinishedSpan setTags(Map<String, String> tags) {
        this.mutableSpan.tags().clear();
        tags.forEach((arg_0, arg_1) -> ((MutableSpan)this.mutableSpan).tag(arg_0, arg_1));
        return this;
    }

    public Map<String, String> getTags() {
        return this.mutableSpan.tags();
    }

    public FinishedSpan setEvents(Collection<Map.Entry<Long, String>> events) {
        this.mutableSpan.annotations().clear();
        events.forEach(e -> this.mutableSpan.annotate(((Long)e.getKey()).longValue(), (String)e.getValue()));
        return this;
    }

    public Collection<Map.Entry<Long, String>> getEvents() {
        return this.mutableSpan.annotations();
    }

    public String getSpanId() {
        return this.mutableSpan.id();
    }

    public String getParentId() {
        return this.mutableSpan.parentId();
    }

    public String getRemoteIp() {
        return this.mutableSpan.remoteIp();
    }

    public String getLocalIp() {
        return this.mutableSpan.localIp();
    }

    public FinishedSpan setLocalIp(String ip) {
        this.mutableSpan.localIp(ip);
        return this;
    }

    public int getRemotePort() {
        return this.mutableSpan.remotePort();
    }

    public FinishedSpan setRemotePort(int port) {
        this.mutableSpan.remotePort(port);
        return this;
    }

    public String getTraceId() {
        return this.mutableSpan.traceId();
    }

    public Throwable getError() {
        return this.mutableSpan.error();
    }

    public FinishedSpan setError(Throwable error) {
        this.mutableSpan.error(error);
        return this;
    }

    public Span.Kind getKind() {
        if (this.mutableSpan.kind() == null) {
            return null;
        }
        return Span.Kind.valueOf((String)this.mutableSpan.kind().name());
    }

    public String getRemoteServiceName() {
        return this.mutableSpan.remoteServiceName();
    }

    public FinishedSpan setRemoteServiceName(String remoteServiceName) {
        this.mutableSpan.remoteServiceName(remoteServiceName);
        return this;
    }

    public String toString() {
        return "BraveFinishedSpan{mutableSpan=" + this.mutableSpan + '}';
    }
}

