/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.brave.bridge;

import brave.propagation.TraceContextOrSamplingFlags;
import io.micrometer.tracing.Baggage;
import io.micrometer.tracing.BaggageInScope;
import io.micrometer.tracing.BaggageManager;
import io.micrometer.tracing.CurrentTraceContext;
import io.micrometer.tracing.ScopedSpan;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.SpanCustomizer;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.brave.bridge.BraveBaggageManager;
import io.micrometer.tracing.brave.bridge.BraveScopedSpan;
import io.micrometer.tracing.brave.bridge.BraveSpan;
import io.micrometer.tracing.brave.bridge.BraveSpanBuilder;
import io.micrometer.tracing.brave.bridge.BraveSpanCustomizer;
import io.micrometer.tracing.brave.bridge.BraveSpanInScope;
import io.micrometer.tracing.brave.bridge.BraveTraceContext;
import io.micrometer.tracing.brave.bridge.BraveTraceContextBuilder;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;

public class BraveTracer
implements Tracer {
    private final brave.Tracer tracer;
    private final BaggageManager braveBaggageManager;
    private final CurrentTraceContext currentTraceContext;

    public BraveTracer(brave.Tracer tracer, CurrentTraceContext context, BaggageManager braveBaggageManager) {
        this.tracer = tracer;
        this.braveBaggageManager = braveBaggageManager;
        this.currentTraceContext = context;
        if (braveBaggageManager instanceof BraveBaggageManager) {
            ((BraveBaggageManager)braveBaggageManager).setTracer(this);
        }
    }

    public BraveTracer(brave.Tracer tracer, CurrentTraceContext context) {
        this(tracer, context, (BaggageManager)NOOP);
    }

    public @Nullable Span nextSpan(@Nullable Span parent) {
        if (parent == null) {
            return this.nextSpan();
        }
        brave.propagation.TraceContext context = ((BraveTraceContext)parent.context()).traceContext;
        if (context == null) {
            return null;
        }
        return new BraveSpan(this.tracer.nextSpan(TraceContextOrSamplingFlags.create((brave.propagation.TraceContext)context)));
    }

    public Tracer.SpanInScope withSpan(@Nullable Span span) {
        return new BraveSpanInScope(this.tracer.withSpanInScope(span == null ? null : ((BraveSpan)span).delegate));
    }

    public SpanCustomizer currentSpanCustomizer() {
        return new BraveSpanCustomizer(this.tracer.currentSpanCustomizer());
    }

    public @Nullable Span currentSpan() {
        brave.Span currentSpan = this.tracer.currentSpan();
        if (currentSpan == null) {
            return null;
        }
        return new BraveSpan(currentSpan);
    }

    public Span nextSpan() {
        return new BraveSpan(this.tracer.nextSpan());
    }

    public ScopedSpan startScopedSpan(String name) {
        return new BraveScopedSpan(this.tracer.startScopedSpan(name));
    }

    public Span.Builder spanBuilder() {
        return new BraveSpanBuilder(this.tracer);
    }

    public TraceContext.Builder traceContextBuilder() {
        return new BraveTraceContextBuilder();
    }

    public Map<String, String> getAllBaggage(@Nullable TraceContext traceContext) {
        return this.braveBaggageManager.getAllBaggage(traceContext);
    }

    public Map<String, String> getAllBaggage() {
        return this.braveBaggageManager.getAllBaggage();
    }

    public @Nullable Baggage getBaggage(String name) {
        return this.braveBaggageManager.getBaggage(name);
    }

    public @Nullable Baggage getBaggage(TraceContext traceContext, String name) {
        return this.braveBaggageManager.getBaggage(traceContext, name);
    }

    @Deprecated
    public Baggage createBaggage(String name) {
        return this.braveBaggageManager.createBaggage(name);
    }

    @Deprecated
    public Baggage createBaggage(String name, String value) {
        return this.braveBaggageManager.createBaggage(name).set(value);
    }

    public BaggageInScope createBaggageInScope(String name, String value) {
        return this.braveBaggageManager.createBaggageInScope(name, value);
    }

    public BaggageInScope createBaggageInScope(TraceContext traceContext, String name, String value) {
        return this.braveBaggageManager.createBaggageInScope(traceContext, name, value);
    }

    public CurrentTraceContext currentTraceContext() {
        return this.currentTraceContext;
    }

    public List<String> getBaggageFields() {
        return this.braveBaggageManager.getBaggageFields();
    }
}

