/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.test;

import io.micrometer.common.util.StringUtils;
import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.observation.DefaultMeterObservationHandler;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.observation.TestConfigAccessor;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.test.reporter.BuildingBlocks;
import io.micrometer.tracing.test.reporter.inmemory.InMemoryBraveSetup;
import io.micrometer.tracing.test.reporter.inmemory.InMemoryOtelSetup;
import io.micrometer.tracing.test.reporter.wavefront.WavefrontBraveSetup;
import io.micrometer.tracing.test.reporter.wavefront.WavefrontOtelSetup;
import io.micrometer.tracing.test.reporter.zipkin.ZipkinBraveSetup;
import io.micrometer.tracing.test.reporter.zipkin.ZipkinOtelSetup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Locale;
import java.util.function.BiConsumer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import zipkin2.reporter.BytesMessageSender;

public abstract class SampleTestRunner {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(SampleTestRunner.class);
    private SampleRunnerConfig sampleRunnerConfig;
    private ObservationRegistry observationRegistry;
    private MeterRegistry meterRegistry;

    public SampleTestRunner(SampleRunnerConfig sampleRunnerConfig) {
        this.sampleRunnerConfig = sampleRunnerConfig;
    }

    public SampleTestRunner() {
        this.sampleRunnerConfig = SampleRunnerConfig.builder().build();
    }

    protected MeterRegistry createMeterRegistry() {
        return new SimpleMeterRegistry();
    }

    protected MeterRegistry getMeterRegistry() {
        Assertions.assertNotNull((Object)this.meterRegistry, (String)"MeterRegistry must be set either via constructor via overriding a method");
        return this.meterRegistry;
    }

    protected ObservationRegistry createObservationRegistry() {
        ObservationRegistry registry = ObservationRegistry.create();
        registry.observationConfig().observationHandler((ObservationHandler)new DefaultMeterObservationHandler(this.getMeterRegistry()));
        return registry;
    }

    protected ObservationRegistry getObservationRegistry() {
        Assertions.assertNotNull((Object)this.observationRegistry, (String)"ObservationRegistry must be set either via constructor via overriding a method");
        return this.observationRegistry;
    }

    protected SampleRunnerConfig getSampleRunnerConfig() {
        return this.sampleRunnerConfig;
    }

    @ParameterizedTest
    @EnumSource(value=TracingSetup.class)
    void run(TracingSetup tracingSetup) {
        tracingSetup.run(this.getSampleRunnerConfig(), this.getObservationRegistry(), this.getMeterRegistry(), this);
    }

    @BeforeEach
    protected void setupRegistry() {
        this.meterRegistry = this.createMeterRegistry();
        this.observationRegistry = this.createObservationRegistry();
    }

    @AfterEach
    protected void closeMeterRegistry() {
        this.getMeterRegistry().close();
    }

    private void printMetrics() {
        StringBuilder stringBuilder = new StringBuilder();
        this.getMeterRegistry().forEachMeter(meter -> stringBuilder.append("\tMeter with name <").append(meter.getId().getName()).append(">").append(" and type <").append(meter.getId().getType()).append(">").append(" has the following measurements \n\t\t<").append(meter.measure()).append(">").append(" \n\t\tand has the following tags <").append(meter.getId().getTags()).append(">\n"));
        log.info("Gathered the following metrics\n" + stringBuilder);
    }

    public abstract SampleTestRunnerConsumer yourCode() throws Exception;

    private SampleTestRunnerConsumer runWithMetricsPrinting() {
        return (bb, registry) -> {
            try {
                this.yourCode().accept(bb, registry);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.printMetrics();
            }
        };
    }

    public BiConsumer<BuildingBlocks, Deque<ObservationHandler<? extends Observation.Context>>> customizeObservationHandlers() {
        return (tracer, ObservationHandlers) -> {};
    }

    public TracingSetup[] getTracingSetup() {
        return TracingSetup.values();
    }

    @FunctionalInterface
    public static interface SampleTestRunnerConsumer {
        public void accept(BuildingBlocks var1, MeterRegistry var2) throws Exception;
    }

    public static class SampleRunnerConfig {
        private String wavefrontToken;
        private String wavefrontServerUrl;
        String zipkinUrl;
        private String wavefrontApplicationName;
        private String wavefrontServiceName;
        private String wavefrontSource;

        SampleRunnerConfig(String wavefrontToken, String wavefrontServerUrl, String wavefrontApplicationName, String wavefrontServiceName, String wavefrontSource, String zipkinUrl) {
            this.wavefrontToken = wavefrontToken;
            this.wavefrontServerUrl = wavefrontServerUrl != null ? wavefrontServerUrl : "https://vmware.wavefront.com";
            this.wavefrontApplicationName = wavefrontApplicationName != null ? wavefrontApplicationName : "test-application";
            this.wavefrontServiceName = wavefrontServiceName != null ? wavefrontServiceName : "test-service";
            this.wavefrontSource = wavefrontSource != null ? wavefrontSource : "test-source";
            this.zipkinUrl = zipkinUrl != null ? zipkinUrl : "http://localhost:9411";
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String wavefrontToken;
            private String wavefrontUrl;
            private String wavefrontApplicationName;
            private String wavefrontServiceName;
            private String wavefrontSource;
            private String zipkinUrl;

            public Builder wavefrontToken(String wavefrontToken) {
                this.wavefrontToken = wavefrontToken;
                return this;
            }

            public Builder wavefrontUrl(String wavefrontUrl) {
                this.wavefrontUrl = wavefrontUrl;
                return this;
            }

            public Builder zipkinUrl(String zipkinUrl) {
                this.zipkinUrl = zipkinUrl;
                return this;
            }

            public Builder wavefrontApplicationName(String wavefrontApplicationName) {
                this.wavefrontApplicationName = wavefrontApplicationName;
                return this;
            }

            public Builder wavefrontServiceName(String wavefrontServiceName) {
                this.wavefrontServiceName = wavefrontServiceName;
                return this;
            }

            public Builder wavefrontSource(String wavefrontSource) {
                this.wavefrontSource = wavefrontSource;
                return this;
            }

            public SampleRunnerConfig build() {
                return new SampleRunnerConfig(this.wavefrontToken, this.wavefrontUrl, this.wavefrontApplicationName, this.wavefrontServiceName, this.wavefrontSource, this.zipkinUrl);
            }
        }
    }

    public static enum TracingSetup {
        IN_MEMORY_OTEL{

            @Override
            void run(SampleRunnerConfig sampleRunnerConfig, ObservationRegistry observationRegistry, MeterRegistry meterRegistry, SampleTestRunner sampleTestRunner) {
                TracingSetup.checkTracingSetupAssumptions(1.IN_MEMORY_OTEL, sampleTestRunner.getTracingSetup());
                TracingSetup.scopeObservationHandlers(observationRegistry, () -> {
                    InMemoryOtelSetup setup = InMemoryOtelSetup.builder().observationHandlerCustomizer(sampleTestRunner.customizeObservationHandlers()).register(observationRegistry);
                    InMemoryOtelSetup.run(setup, __ -> TracingSetup.runTraced(sampleRunnerConfig, 1.IN_MEMORY_OTEL, setup.getBuildingBlocks(), observationRegistry, meterRegistry, sampleTestRunner.runWithMetricsPrinting()));
                });
            }

            @Override
            void printTracingLink(SampleRunnerConfig sampleRunnerConfig, String traceId) {
                log.info("In memory tracing used. All spans should have trace id <{}>", (Object)traceId);
            }
        }
        ,
        IN_MEMORY_BRAVE{

            @Override
            void run(SampleRunnerConfig sampleRunnerConfig, ObservationRegistry observationRegistry, MeterRegistry meterRegistry, SampleTestRunner sampleTestRunner) {
                TracingSetup.checkTracingSetupAssumptions(2.IN_MEMORY_BRAVE, sampleTestRunner.getTracingSetup());
                TracingSetup.scopeObservationHandlers(observationRegistry, () -> {
                    InMemoryBraveSetup setup = InMemoryBraveSetup.builder().observationHandlerCustomizer(sampleTestRunner.customizeObservationHandlers()).register(observationRegistry);
                    InMemoryBraveSetup.run(setup, __ -> TracingSetup.runTraced(sampleRunnerConfig, 2.IN_MEMORY_BRAVE, setup.getBuildingBlocks(), observationRegistry, meterRegistry, sampleTestRunner.runWithMetricsPrinting()));
                });
            }

            @Override
            void printTracingLink(SampleRunnerConfig sampleRunnerConfig, String traceId) {
                log.info("In memory tracing used. All spans should have trace id <{}>", (Object)traceId);
            }
        }
        ,
        ZIPKIN_OTEL{

            @Override
            void run(SampleRunnerConfig sampleRunnerConfig, ObservationRegistry observationRegistry, MeterRegistry meterRegistry, SampleTestRunner sampleTestRunner) {
                TracingSetup.checkTracingSetupAssumptions(3.ZIPKIN_OTEL, sampleTestRunner.getTracingSetup());
                TracingSetup.scopeObservationHandlers(observationRegistry, () -> {
                    ZipkinOtelSetup setup = ZipkinOtelSetup.builder().observationHandlerCustomizer(sampleTestRunner.customizeObservationHandlers()).zipkinUrl(sampleRunnerConfig.zipkinUrl).register(observationRegistry);
                    TracingSetup.checkZipkinAssumptions(setup.getBuildingBlocks().getSender());
                    ZipkinOtelSetup.run(setup, __ -> TracingSetup.runTraced(sampleRunnerConfig, 3.ZIPKIN_OTEL, setup.getBuildingBlocks(), observationRegistry, meterRegistry, sampleTestRunner.runWithMetricsPrinting()));
                });
            }

            @Override
            void printTracingLink(SampleRunnerConfig sampleRunnerConfig, String traceId) {
                log.info("Below you can find the link to the trace in Zipkin with id <{}>", (Object)traceId);
                log.info("{}/zipkin/traces/{}", (Object)sampleRunnerConfig.zipkinUrl, (Object)traceId);
            }
        }
        ,
        ZIPKIN_BRAVE{

            @Override
            void run(SampleRunnerConfig sampleRunnerConfig, ObservationRegistry observationRegistry, MeterRegistry meterRegistry, SampleTestRunner sampleTestRunner) {
                TracingSetup.checkTracingSetupAssumptions(4.ZIPKIN_BRAVE, sampleTestRunner.getTracingSetup());
                TracingSetup.scopeObservationHandlers(observationRegistry, () -> {
                    ZipkinBraveSetup setup = ZipkinBraveSetup.builder().observationHandlerCustomizer(sampleTestRunner.customizeObservationHandlers()).zipkinUrl(sampleRunnerConfig.zipkinUrl).register(observationRegistry);
                    TracingSetup.checkZipkinAssumptions(setup.getBuildingBlocks().getSender());
                    ZipkinBraveSetup.run(setup, __ -> TracingSetup.runTraced(sampleRunnerConfig, 4.ZIPKIN_BRAVE, setup.getBuildingBlocks(), observationRegistry, meterRegistry, sampleTestRunner.runWithMetricsPrinting()));
                });
            }

            @Override
            void printTracingLink(SampleRunnerConfig sampleRunnerConfig, String traceId) {
                log.info("Below you can find the link to the trace in Zipkin with id <{}>", (Object)traceId);
                log.info("{}/zipkin/traces/{}", (Object)sampleRunnerConfig.zipkinUrl, (Object)traceId);
            }
        }
        ,
        WAVEFRONT_OTEL{

            @Override
            void run(SampleRunnerConfig sampleRunnerConfig, ObservationRegistry observationRegistry, MeterRegistry meterRegistry, SampleTestRunner sampleTestRunner) {
                TracingSetup.checkTracingSetupAssumptions(5.WAVEFRONT_OTEL, sampleTestRunner.getTracingSetup());
                TracingSetup.checkWavefrontAssumptions(sampleRunnerConfig);
                TracingSetup.scopeObservationHandlers(observationRegistry, () -> {
                    WavefrontOtelSetup setup = WavefrontOtelSetup.builder(sampleRunnerConfig.wavefrontServerUrl, sampleRunnerConfig.wavefrontToken).applicationName(sampleRunnerConfig.wavefrontApplicationName).serviceName(sampleRunnerConfig.wavefrontServiceName).source(sampleRunnerConfig.wavefrontSource).observationHandlerCustomizer(sampleTestRunner.customizeObservationHandlers()).register(observationRegistry, meterRegistry);
                    WavefrontOtelSetup.run(setup, __ -> TracingSetup.runTraced(sampleRunnerConfig, 5.WAVEFRONT_OTEL, setup.getBuildingBlocks(), observationRegistry, meterRegistry, sampleTestRunner.runWithMetricsPrinting()));
                });
            }

            @Override
            void printTracingLink(SampleRunnerConfig sampleRunnerConfig, String traceId) {
                log.info("Below you can find the link to the trace in Wavefront with id <{}>", (Object)traceId);
                String wavefrontUrl = sampleRunnerConfig.wavefrontServerUrl.endsWith("/") ? sampleRunnerConfig.wavefrontServerUrl.substring(0, sampleRunnerConfig.wavefrontServerUrl.length() - 1) : sampleRunnerConfig.wavefrontServerUrl;
                log.info("{}/tracing/search?sortBy=MOST_RECENT&traceID={}", (Object)wavefrontUrl, (Object)traceId);
            }
        }
        ,
        WAVEFRONT_BRAVE{

            @Override
            void run(SampleRunnerConfig sampleRunnerConfig, ObservationRegistry observationRegistry, MeterRegistry meterRegistry, SampleTestRunner sampleTestRunner) {
                TracingSetup.checkTracingSetupAssumptions(6.WAVEFRONT_BRAVE, sampleTestRunner.getTracingSetup());
                TracingSetup.checkWavefrontAssumptions(sampleRunnerConfig);
                TracingSetup.scopeObservationHandlers(observationRegistry, () -> {
                    WavefrontBraveSetup setup = WavefrontBraveSetup.builder(sampleRunnerConfig.wavefrontServerUrl, sampleRunnerConfig.wavefrontToken).applicationName(sampleRunnerConfig.wavefrontApplicationName).serviceName(sampleRunnerConfig.wavefrontServiceName).source(sampleRunnerConfig.wavefrontSource).observationHandlerCustomizer(sampleTestRunner.customizeObservationHandlers()).register(meterRegistry, observationRegistry);
                    WavefrontBraveSetup.run(setup, __ -> TracingSetup.runTraced(sampleRunnerConfig, 6.WAVEFRONT_BRAVE, setup.getBuildingBlocks(), observationRegistry, meterRegistry, sampleTestRunner.runWithMetricsPrinting()));
                });
            }

            @Override
            void printTracingLink(SampleRunnerConfig sampleRunnerConfig, String traceId) {
                log.info("Below you can find the link to the trace in Wavefront with id <{}>", (Object)traceId);
                String wavefrontUrl = sampleRunnerConfig.wavefrontServerUrl.endsWith("/") ? sampleRunnerConfig.wavefrontServerUrl.substring(0, sampleRunnerConfig.wavefrontServerUrl.length() - 1) : sampleRunnerConfig.wavefrontServerUrl;
                log.info("{}/tracing/search?sortBy=MOST_RECENT&traceID={}", (Object)wavefrontUrl, (Object)traceId);
            }
        };


        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void scopeObservationHandlers(ObservationRegistry observationRegistry, Runnable runnable) {
            ObservationRegistry.ObservationConfig observationConfig = observationRegistry.observationConfig();
            ArrayList originalHandlers = new ArrayList(TestConfigAccessor.getHandlers(observationConfig));
            try {
                runnable.run();
            }
            finally {
                TestConfigAccessor.clearHandlers(observationConfig);
                originalHandlers.forEach(arg_0 -> ((ObservationRegistry.ObservationConfig)observationConfig).observationHandler(arg_0));
            }
        }

        private static void runTraced(SampleRunnerConfig sampleRunnerConfig, TracingSetup tracingSetup, BuildingBlocks bb, ObservationRegistry observationRegistry, MeterRegistry meterRegistry, SampleTestRunnerConsumer runnable) {
            Observation observation = Observation.start((String)tracingSetup.name().toLowerCase(Locale.ROOT), (ObservationRegistry)observationRegistry);
            String traceId = "";
            try (Observation.Scope ws = observation.openScope();){
                Tracer tracer = bb.getTracer();
                traceId = tracer.currentSpan().context().traceId();
                runnable.accept(bb, meterRegistry);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            finally {
                tracingSetup.printTracingLink(sampleRunnerConfig, traceId);
                observation.stop();
            }
        }

        private static void checkTracingSetupAssumptions(TracingSetup tracingSetup, TracingSetup[] chosenSetups) {
            Assumptions.assumeTrue((boolean)Arrays.asList(chosenSetups).contains((Object)tracingSetup), (String)(tracingSetup.name() + " not found in the list of tracing setups to run " + Arrays.toString((Object[])chosenSetups)));
        }

        private static void checkZipkinAssumptions(BytesMessageSender sender) {
            try {
                sender.send(Collections.emptyList());
            }
            catch (Exception e) {
                Assumptions.abort((String)"There was a problem with connecting to Zipkin. Will NOT run any tests");
            }
        }

        private static void checkWavefrontAssumptions(SampleRunnerConfig sampleRunnerConfig) {
            Assumptions.assumeTrue((boolean)StringUtils.isNotBlank((String)sampleRunnerConfig.wavefrontServerUrl), (String)"To run tests against Tanzu Observability by Wavefront you need to set the Wavefront server url");
            Assumptions.assumeTrue((boolean)StringUtils.isNotBlank((String)sampleRunnerConfig.wavefrontToken), (String)"To run tests against Tanzu Observability by Wavefront you need to set the Wavefront token");
        }

        abstract void run(SampleRunnerConfig var1, ObservationRegistry var2, MeterRegistry var3, SampleTestRunner var4);

        abstract void printTracingLink(SampleRunnerConfig var1, String var2);
    }
}

