/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.handler;

import io.micrometer.observation.Observation;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.handler.TracingObservationHandler;

public class DefaultTracingObservationHandler
implements TracingObservationHandler<Observation.Context> {
    private final Tracer tracer;

    public DefaultTracingObservationHandler(Tracer tracer) {
        this.tracer = tracer;
    }

    public void onStart(Observation.Context context) {
        Span parentSpan = this.getParentSpan((Observation.ContextView)context);
        Span childSpan = parentSpan != null ? this.getTracer().nextSpan(parentSpan) : this.getTracer().nextSpan();
        childSpan.start();
        this.getTracingContext(context).setSpan(childSpan);
    }

    public void onStop(Observation.Context context) {
        Span span = this.getRequiredSpan(context);
        span.name(this.getSpanName(context));
        this.tagSpan(context, span);
        span.end();
    }

    @Override
    public void onError(Observation.Context context) {
        Span span = this.getTracingContext(context).getSpan();
        if (context.getError() != null) {
            span.error(context.getError());
        }
    }

    @Override
    public Tracer getTracer() {
        return this.tracer;
    }
}

