/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aot.core.codegen;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.micronaut.aot.core.AOTCodeGenerator;
import io.micronaut.aot.core.AOTContext;
import io.micronaut.aot.core.AOTModule;
import io.micronaut.aot.core.codegen.AbstractCodeGenerator;
import io.micronaut.aot.core.codegen.DelegatingSourceGenerationContext;
import io.micronaut.aot.core.codegen.MapGenerator;
import io.micronaut.aot.core.config.MetadataUtils;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.ApplicationContextConfigurer;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.CollectionUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

public class ApplicationContextConfigurerGenerator
extends AbstractCodeGenerator {
    public static final String ID = "application.context.customizer";
    public static final String CUSTOMIZER_CLASS_NAME = "AOTApplicationContextConfigurer";
    private final List<AOTCodeGenerator> sourceGenerators;

    public ApplicationContextConfigurerGenerator(List<AOTCodeGenerator> sourceGenerators) {
        this.sourceGenerators = sourceGenerators;
    }

    @Override
    public void generate(@NonNull AOTContext context) {
        TypeSpec.Builder optimizedEntryPoint = TypeSpec.classBuilder((String)CUSTOMIZER_CLASS_NAME).addSuperinterface(ApplicationContextConfigurer.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        CodeBlock.Builder staticInitializer = CodeBlock.builder();
        StaticInitializerCapturingContext capturer = new StaticInitializerCapturingContext(context, optimizedEntryPoint, staticInitializer);
        for (AOTCodeGenerator sourceGenerator : this.sourceGenerators) {
            sourceGenerator.generate(capturer);
        }
        this.addDiagnostics(context, optimizedEntryPoint);
        optimizedEntryPoint.addStaticBlock(staticInitializer.build());
        context.registerGeneratedSourceFile(context.javaFile(optimizedEntryPoint.build()));
        context.registerServiceImplementation(ApplicationContextConfigurer.class, CUSTOMIZER_CLASS_NAME);
        context.finish();
    }

    private void addDiagnostics(AOTContext context, TypeSpec.Builder optimizedEntryPoint) {
        MethodSpec.Builder configure = MethodSpec.methodBuilder((String)"configure").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(ApplicationContextBuilder.class, "builder", new Modifier[0]);
        MapGenerator mapGenerator = new MapGenerator();
        CodeBlock mapBlock = mapGenerator.generateMap(optimizedEntryPoint, this.createDiagnosticsMap(context));
        configure.addStatement("builder.properties($L)", new Object[]{mapBlock});
        optimizedEntryPoint.addMethod(configure.build());
    }

    private Map<String, Object> createDiagnosticsMap(AOTContext context) {
        LinkedHashMap values = CollectionUtils.newLinkedHashMap((int)3);
        values.put("micronaut.aot.enabled", true);
        values.put("micronaut.aot.runtime", context.getRuntime().toString());
        values.put("micronaut.aot.optimizations", this.buildOptimizationList());
        return values;
    }

    private List<String> buildOptimizationList() {
        return this.sourceGenerators.stream().map(Object::getClass).map(MetadataUtils::findMetadata).filter(Optional::isPresent).map(Optional::get).map(AOTModule::id).collect(Collectors.toList());
    }

    private static final class StaticInitializerCapturingContext
    extends DelegatingSourceGenerationContext {
        private final AOTContext delegate;
        private final TypeSpec.Builder optimizedEntryPoint;
        private final CodeBlock.Builder initializer;

        private StaticInitializerCapturingContext(AOTContext delegate, TypeSpec.Builder optimizedEntryPoint, CodeBlock.Builder initializer) {
            super(delegate);
            this.delegate = delegate;
            this.optimizedEntryPoint = optimizedEntryPoint;
            this.initializer = initializer;
        }

        @Override
        public void registerStaticInitializer(MethodSpec staticInitializer) {
            this.delegate.registerStaticInitializer(staticInitializer);
            StaticInitializerCapturingContext.appendInitializer(this.optimizedEntryPoint, this.initializer, staticInitializer);
        }

        private static void appendInitializer(TypeSpec.Builder optimizedEntryPoint, CodeBlock.Builder staticInitializer, MethodSpec method) {
            optimizedEntryPoint.addMethod(method);
            if (method.returnType.equals((Object)TypeName.VOID)) {
                staticInitializer.addStatement("$L()", new Object[]{method.name});
            } else {
                staticInitializer.addStatement("$T _$L = $L()", new Object[]{method.returnType, method.name, method.name});
            }
        }
    }
}

