/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aot.std.sourcegen;

import io.micronaut.aot.core.AOTContext;
import io.micronaut.aot.core.AOTModule;
import io.micronaut.aot.core.Option;
import io.micronaut.aot.core.Runtime;
import io.micronaut.aot.core.codegen.AbstractCodeGenerator;
import io.micronaut.aot.core.config.MetadataUtils;
import io.micronaut.core.annotation.NonNull;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

@AOTModule(id="graalvm.config", description="Generates GraalVM configuration files required to load the AOT optimizations", options={@Option(key="service.types", description="The list of service types to be scanned (comma separated)", sampleValue="io.micronaut.Service1,io.micronaut.Service2")}, enabledOn={Runtime.NATIVE})
public class GraalVMOptimizationFeatureSourceGenerator
extends AbstractCodeGenerator {
    public static final String ID = "graalvm.config";
    public static final String DESCRIPTION = "Generates GraalVM configuration files required to load the AOT optimizations";
    private static final String NEXT_LINE = " \\\n     ";
    private static final Option OPTION = MetadataUtils.findOption(GraalVMOptimizationFeatureSourceGenerator.class, (String)"service.types");

    public void generate(@NonNull AOTContext context) {
        List serviceTypes = context.getConfiguration().stringList(OPTION.key());
        String path = "META-INF/native-image/" + context.getPackageName() + "/native-image.properties";
        context.registerGeneratedResource(path, propertiesFile -> {
            try (PrintWriter wrt = new PrintWriter(new FileWriter((File)propertiesFile));){
                wrt.print("Args=");
                wrt.print("--initialize-at-build-time=io.micronaut.context.ApplicationContextConfigurer$1");
                wrt.print(NEXT_LINE);
                wrt.print("--initialize-at-build-time=" + context.getPackageName() + ".AOTApplicationContextConfigurer");
                for (String buildTimeInitClass : context.getBuildTimeInitClasses()) {
                    wrt.print(NEXT_LINE);
                    wrt.print("--initialize-at-build-time=" + buildTimeInitClass);
                }
                if (context.getConfiguration().isFeatureEnabled("serviceloading.native")) {
                    for (int i = 0; i < serviceTypes.size(); ++i) {
                        String serviceType = (String)serviceTypes.get(i);
                        wrt.print(NEXT_LINE);
                        wrt.print("-H:ServiceLoaderFeatureExcludeServices=" + serviceType);
                    }
                }
                wrt.println();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

