/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.cloud.aws;

import java.net.MalformedURLException;
import java.net.URL;

public enum EC2MetadataKeys {
    instanceId("instance-id"),
    amiId("ami-id"),
    region("region"),
    instanceType("instance-type"),
    localIpv4("local-ipv4"),
    localHostname("local-hostname"),
    availabilityZone("availability-zone", "placement/"),
    publicHostname("public-hostname"),
    publicIpv4("public-ipv4"),
    mac("mac"),
    vpcId("vpc-id", "network/interfaces/macs/"){

        @Override
        public URL getURL(String prepend, String mac) throws MalformedURLException {
            return new URL(EC2MetadataKeys.AWS_METADATA_URL + this.path + mac + "/" + this.getName());
        }
    }
    ,
    accountId("accountId");

    public static final String AWS_API_VERSION = "latest";
    public static final String AWS_METADATA_URL = "http://169.254.169.254/latest/meta-data/";
    protected String path;
    private String name;

    private EC2MetadataKeys(String name) {
        this(name, "");
    }

    private EC2MetadataKeys(String name, String path) {
        this.name = name;
        this.path = path;
    }

    public String getName() {
        return this.name;
    }

    public URL getURL(String prepend, String append) throws MalformedURLException {
        return new URL(AWS_METADATA_URL + this.path + this.name);
    }

    public String toString() {
        return this.getName();
    }
}

