/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.hibernate.validator;

import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.exceptions.BeanInstantiationException;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.validation.validator.DefaultValidator;
import io.micronaut.validation.validator.ValidatorConfiguration;
import jakarta.inject.Singleton;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.metadata.BeanDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Set;

@Singleton
@Primary
@Requires(property="micronaut.validator.enabled", value="true", defaultValue="true")
@Replaces(value=DefaultValidator.class)
public class MicronautHibernateValidator
extends DefaultValidator {
    private final Validator validator;

    protected MicronautHibernateValidator(ValidatorFactory validatorFactory, @NonNull ValidatorConfiguration configuration) {
        super(configuration);
        this.validator = validatorFactory.getValidator();
    }

    @NonNull
    public <T> Set<ConstraintViolation<T>> validate(@NonNull T object, Class<?> ... groups) {
        return this.validator.validate(object, (Class[])groups);
    }

    @NonNull
    public <T> Set<ConstraintViolation<T>> validateProperty(@NonNull T object, @NonNull String propertyName, Class<?> ... groups) {
        return this.validator.validateProperty(object, propertyName, (Class[])groups);
    }

    @NonNull
    public <T> Set<ConstraintViolation<T>> validateValue(@NonNull Class<T> beanType, @NonNull String propertyName, @Nullable Object value, Class<?> ... groups) {
        return this.validator.validateValue(beanType, propertyName, value, (Class[])groups);
    }

    public BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        return this.validator.getConstraintsForClass(clazz);
    }

    public <T> T unwrap(Class<T> type) {
        return (T)this.validator.unwrap(type);
    }

    @NonNull
    public <T> Set<ConstraintViolation<T>> validateReturnValue(@NonNull T object, @NonNull Method method, @Nullable Object returnValue, Class<?> ... groups) {
        return this.validator.forExecutables().validateReturnValue(object, method, returnValue, (Class[])groups);
    }

    @NonNull
    public <T> Set<ConstraintViolation<T>> validateConstructorParameters(@NonNull Constructor<? extends T> constructor, @NonNull Object[] parameterValues, Class<?> ... groups) {
        return this.validator.forExecutables().validateConstructorParameters(constructor, parameterValues, (Class[])groups);
    }

    @NonNull
    public <T> Set<ConstraintViolation<T>> validateConstructorReturnValue(@NonNull Constructor<? extends T> constructor, @NonNull T createdObject, Class<?> ... groups) {
        return this.validator.forExecutables().validateConstructorReturnValue(constructor, createdObject, (Class[])groups);
    }

    public <T> void validateBean(@NonNull BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> definition, @NonNull T bean) throws BeanInstantiationException {
        Set violations = this.validator.validate(bean, new Class[0]);
        Class<?> beanType = bean.getClass();
        this.failOnError(resolutionContext, violations, beanType);
    }

    private <T> void failOnError(@NonNull BeanResolutionContext resolutionContext, Set<ConstraintViolation<T>> errors, Class<?> beanType) {
        if (errors.isEmpty()) {
            return;
        }
        StringBuilder builder = new StringBuilder("Validation failed for bean definition [").append(beanType.getName()).append("]\nList of constraint violations:[\n");
        for (ConstraintViolation<T> violation : errors) {
            builder.append('\t').append(violation.getPropertyPath()).append(" - ").append(violation.getMessage()).append('\n');
        }
        builder.append(']');
        throw new BeanInstantiationException(resolutionContext, builder.toString());
    }
}

