/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build;

import com.google.cloud.tools.jib.api.Containerizer;
import com.google.cloud.tools.jib.api.DockerDaemonImage;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.Jib;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.frontend.CredentialRetrieverFactory;
import io.micronaut.build.AbstractDockerMojo;
import io.micronaut.build.services.ApplicationConfigurationService;
import io.micronaut.build.services.DockerService;
import io.micronaut.build.services.JibConfigurationService;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;

@Mojo(name="docker-push")
public class DockerPushMojo
extends AbstractDockerMojo {
    @Inject
    public DockerPushMojo(MavenProject mavenProject, JibConfigurationService jibConfigurationService, ApplicationConfigurationService applicationConfigurationService, DockerService dockerService) {
        super(mavenProject, jibConfigurationService, applicationConfigurationService, dockerService);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        String packaging = this.mavenProject.getPackaging();
        if (!"docker".equals(packaging) && !"docker-native".equals(packaging)) throw new MojoFailureException("The <packaging> must be set to either [docker] or [docker-native]");
        Optional<String> toImage = this.jibConfigurationService.getToImage();
        if (!toImage.isPresent()) throw new MojoFailureException("The plugin com.google.cloud.tools:jib-maven-plugin is misconfigured. Missing <to> tag");
        this.getLog().info((CharSequence)("Pushing image: " + toImage.get()));
        try {
            ImageReference imageReference = ImageReference.parse((String)toImage.get());
            DockerDaemonImage dockerDaemonImage = DockerDaemonImage.named((String)toImage.get());
            RegistryImage targetImage = RegistryImage.named((ImageReference)imageReference);
            CredentialRetrieverFactory credentialRetrieverFactory = CredentialRetrieverFactory.forImage((ImageReference)imageReference, logEvent -> this.getLog().info((CharSequence)logEvent.getMessage()));
            targetImage.addCredentialRetriever(credentialRetrieverFactory.dockerConfig());
            targetImage.addCredentialRetriever(credentialRetrieverFactory.wellKnownCredentialHelpers());
            this.jibConfigurationService.getCredentials().ifPresent(c -> targetImage.addCredential(c.getUsername(), c.getPassword()));
            this.jibConfigurationService.getCredHelper().ifPresent(credHelper -> targetImage.addCredentialRetriever(credentialRetrieverFactory.dockerCredentialHelper(credHelper)));
            Containerizer containerizer = Containerizer.to((RegistryImage)targetImage);
            Jib.from((DockerDaemonImage)dockerDaemonImage).containerize(containerizer);
            return;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }
}

