/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.jib;

import com.google.cloud.tools.jib.api.buildplan.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.buildplan.ContainerBuildPlan;
import com.google.cloud.tools.jib.api.buildplan.FileEntriesLayer;
import com.google.cloud.tools.jib.api.buildplan.FileEntry;
import com.google.cloud.tools.jib.api.buildplan.LayerObject;
import com.google.cloud.tools.jib.api.buildplan.Port;
import com.google.cloud.tools.jib.buildplan.UnixPathParser;
import com.google.cloud.tools.jib.maven.extension.JibMavenPluginExtension;
import com.google.cloud.tools.jib.maven.extension.MavenData;
import com.google.cloud.tools.jib.plugins.extension.ExtensionLogger;
import com.google.cloud.tools.jib.plugins.extension.JibPluginExtensionException;
import io.micronaut.build.MicronautRuntime;
import io.micronaut.build.services.ApplicationConfigurationService;
import io.micronaut.build.services.JibConfigurationService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class JibMicronautExtension
implements JibMavenPluginExtension<Void> {
    public static final String DEFAULT_BASE_IMAGE = "openjdk:15-alpine";

    public Optional<Class<Void>> getExtraConfigType() {
        return Optional.empty();
    }

    public ContainerBuildPlan extendContainerBuildPlan(ContainerBuildPlan buildPlan, Map<String, String> properties, Optional<Void> extraConfig, MavenData mavenData, ExtensionLogger logger) throws JibPluginExtensionException {
        ContainerBuildPlan.Builder builder = buildPlan.toBuilder();
        MicronautRuntime runtime = MicronautRuntime.valueOf(mavenData.getMavenProject().getProperties().getProperty("micronaut.runtime", "none").toUpperCase());
        JibConfigurationService jibConfigurationService = new JibConfigurationService(mavenData.getMavenProject());
        String from = jibConfigurationService.getFromImage().orElse(DEFAULT_BASE_IMAGE);
        builder.setBaseImage(from);
        ApplicationConfigurationService applicationConfigurationService = new ApplicationConfigurationService(mavenData.getMavenProject());
        int port = Integer.parseInt(applicationConfigurationService.getServerPort());
        if (port > 0) {
            logger.log(ExtensionLogger.LogLevel.LIFECYCLE, "Exposing port: " + port);
            builder.addExposedPort(Port.tcp((int)port));
        }
        switch (runtime.getBuildStrategy()) {
            case ORACLE_FUNCTION: {
                List originalLayers = buildPlan.getLayers();
                builder.setLayers(Collections.emptyList());
                for (LayerObject layer : originalLayers) {
                    builder.addLayer(this.remapLayer(layer));
                }
                builder.setBaseImage("fnproject/fn-java-fdk:" + this.determineProjectFnVersion()).setWorkingDirectory(AbsoluteUnixPath.get((String)"/function")).setEntrypoint(null).setCmd(Collections.singletonList("io.micronaut.oraclecloud.function.http.HttpFunction::handleRequest"));
                break;
            }
            case LAMBDA: {
                List entrypoint = buildPlan.getEntrypoint();
                Objects.requireNonNull(entrypoint).set(entrypoint.size() - 1, "io.micronaut.function.aws.runtime.MicronautLambdaRuntime");
                builder.setEntrypoint(entrypoint);
            }
        }
        return builder.build();
    }

    private LayerObject remapLayer(LayerObject layerObject) {
        FileEntriesLayer originalLayer = (FileEntriesLayer)layerObject;
        FileEntriesLayer.Builder builder = FileEntriesLayer.builder().setName(originalLayer.getName());
        for (FileEntry originalEntry : originalLayer.getEntries()) {
            builder.addEntry(this.remapEntry(originalEntry));
        }
        return builder.build();
    }

    private FileEntry remapEntry(FileEntry originalEntry) {
        List pathComponents = UnixPathParser.parse((String)originalEntry.getExtractionPath().toString());
        AbsoluteUnixPath newPath = AbsoluteUnixPath.get((String)("/function/app/" + (String)pathComponents.get(pathComponents.size() - 1)));
        return new FileEntry(originalEntry.getSourceFile(), newPath, originalEntry.getPermissions(), originalEntry.getModificationTime(), originalEntry.getOwnership());
    }

    private String determineProjectFnVersion() {
        DefaultArtifactVersion javaVersion = new DefaultArtifactVersion(System.getProperty("java.version"));
        if (javaVersion.getMajorVersion() >= 11) {
            return "jre11-latest";
        }
        return "latest";
    }
}

