/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query.builder;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.data.model.DataType;
import java.util.Collections;
import java.util.Map;

public interface QueryResult {
    @NonNull
    public String getQuery();

    @NonNull
    public Map<String, String> getParameters();

    @NonNull
    public Map<String, DataType> getParameterTypes();

    @NonNull
    public static QueryResult of(final @NonNull String query, final @Nullable Map<String, String> parameters, final @Nullable Map<String, DataType> parameterTypes) {
        ArgumentUtils.requireNonNull((String)"query", (Object)query);
        return new QueryResult(){

            @Override
            @NonNull
            public String getQuery() {
                return query;
            }

            @Override
            @NonNull
            public Map<String, String> getParameters() {
                return parameters != null ? Collections.unmodifiableMap(parameters) : Collections.emptyMap();
            }

            @Override
            @NonNull
            public Map<String, DataType> getParameterTypes() {
                return parameterTypes != null ? Collections.unmodifiableMap(parameterTypes) : Collections.emptyMap();
            }
        };
    }
}

