/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.reactive;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.intercept.reactive.FindOneReactiveInterceptor;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.reactive.AbstractReactiveInterceptor;
import org.reactivestreams.Publisher;

public class DefaultFindOneReactiveInterceptor
extends AbstractReactiveInterceptor<Object, Object>
implements FindOneReactiveInterceptor<Object, Object> {
    protected DefaultFindOneReactiveInterceptor(@NonNull RepositoryOperations operations) {
        super(operations);
    }

    public Object intercept(RepositoryMethodKey methodKey, MethodInvocationContext<Object, Object> context) {
        PreparedQuery<?, ?> preparedQuery = this.prepareQuery(methodKey, context);
        Publisher publisher = this.reactiveOperations.findOptional(preparedQuery);
        Argument returnType = context.getReturnType().asArgument();
        Argument type = returnType.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
        Publisher mappedPublisher = Publishers.map((Publisher)publisher, o -> {
            if (!type.getType().isInstance(o)) {
                return ConversionService.SHARED.convert(o, type).orElseThrow(() -> new IllegalStateException("Unexpected return type: " + o));
            }
            return o;
        });
        return Publishers.convertPublisher((Object)mappedPublisher, (Class)returnType.getType());
    }
}

