/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.mapper;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.reflect.exception.InstantiationException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.runtime.mapper.TypeMapper;
import java.util.Collection;
import java.util.Optional;

@FunctionalInterface
public interface BeanIntrospectionMapper<D, R>
extends TypeMapper<D, R> {
    @Override
    @NonNull
    default public R map(@NonNull D object, @NonNull Class<R> type) throws InstantiationException {
        ArgumentUtils.requireNonNull((String)"resultSet", object);
        ArgumentUtils.requireNonNull((String)"type", type);
        try {
            Object instance;
            BeanIntrospection introspection = BeanIntrospection.getIntrospection(type);
            ConversionService<?> conversionService = this.getConversionService();
            Object[] arguments = introspection.getConstructorArguments();
            if (ArrayUtils.isEmpty((Object[])arguments)) {
                instance = introspection.instantiate();
            } else {
                Object[] args = new Object[arguments.length];
                for (int i = 0; i < arguments.length; ++i) {
                    Object argument = arguments[i];
                    Object o = this.read(object, argument.getName());
                    if (o == null) {
                        args[i] = o;
                        continue;
                    }
                    ArgumentConversionContext acc = ConversionContext.of((Argument)argument);
                    args[i] = argument.getType().isInstance(o) ? o : conversionService.convert(o, acc).orElseThrow(() -> BeanIntrospectionMapper.lambda$map$2(acc, (Argument)argument, o));
                }
                instance = introspection.instantiate(args);
            }
            Collection properties = introspection.getBeanProperties();
            for (BeanProperty property : properties) {
                Object v = this.read(object, property.getName());
                if (property.getType().isInstance(v)) {
                    property.set(instance, v);
                    continue;
                }
                property.convertAndSet(instance, v);
            }
            return (R)instance;
        }
        catch (IntrospectionException | InstantiationException e) {
            throw new DataAccessException("Error instantiating type [" + type.getName() + "] from introspection: " + e.getMessage(), e);
        }
    }

    private static /* synthetic */ RuntimeException lambda$map$2(ArgumentConversionContext acc, Argument argument, Object o) {
        Optional lastError = acc.getLastError();
        return lastError.map(conversionError -> new ConversionErrorException(argument, conversionError)).orElseGet(() -> new IllegalArgumentException("Cannot convert object type " + o.getClass() + " to required type: " + argument.getType()));
    }
}

