/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.mapper;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.runtime.mapper.ResultReader;
import java.math.BigDecimal;
import java.util.Date;
import java.util.function.BiConsumer;

@Introspected
@FunctionalInterface
public interface ResultConsumer<T, RS>
extends BiConsumer<T, Context<RS>> {

    public static interface Context<RS> {
        public RS getResultSet();

        public ResultReader<RS, String> getResultReader();

        @NonNull
        public <E> E readEntity(@NonNull String var1, @NonNull Class<E> var2) throws DataAccessException;

        @NonNull
        public <E, D> D readDTO(@NonNull String var1, @NonNull Class<E> var2, @NonNull Class<D> var3) throws DataAccessException;

        default public long readLong(@NonNull String name) {
            return this.getResultReader().readLong(this.getResultSet(), name);
        }

        default public char readChar(@NonNull String name) {
            return this.getResultReader().readChar(this.getResultSet(), name);
        }

        @Nullable
        default public Date readDate(@NonNull String name) {
            return this.getResultReader().readDate(this.getResultSet(), name);
        }

        @Nullable
        default public Date readTimestamp(@NonNull String name) {
            return this.getResultReader().readTimestamp(this.getResultSet(), name);
        }

        @Nullable
        default public String readString(@NonNull String name) {
            return this.getResultReader().readString(this.getResultSet(), name);
        }

        default public int readInt(@NonNull String name) {
            return this.getResultReader().readInt(this.getResultSet(), name);
        }

        default public boolean readBoolean(@NonNull String name) {
            return this.getResultReader().readBoolean(this.getResultSet(), name);
        }

        default public float readFloat(@NonNull String name) {
            return this.getResultReader().readFloat(this.getResultSet(), name);
        }

        default public byte readByte(@NonNull String name) {
            return this.getResultReader().readByte(this.getResultSet(), name);
        }

        default public short readShort(@NonNull String name) {
            return this.getResultReader().readShort(this.getResultSet(), name);
        }

        default public double readDouble(@NonNull String name) {
            return this.getResultReader().readDouble(this.getResultSet(), name);
        }

        @Nullable
        default public BigDecimal readBigDecimal(@NonNull String name) {
            return this.getResultReader().readBigDecimal(this.getResultSet(), name);
        }

        default public byte[] readBytes(@NonNull String name) {
            return this.getResultReader().readBytes(this.getResultSet(), name);
        }
    }
}

