/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jsonschema.model;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.micronaut.core.annotation.Internal;
import io.micronaut.jsonschema.model.TypeListSerializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@Internal
public final class Schema {
    public static final Schema TRUE = new Schema();
    public static final Schema FALSE = new Schema().setNot(TRUE);
    public static final String THIS_SCHEMA_REF = "#";
    public static final String DEF_SCHEMA_REF_PREFIX = "#/$defs/";
    public static final String ONE_OF_SCHEMA_REF_PREFIX = "#/oneOf/";
    private String $schema;
    private String $id;
    private String $ref;
    private SchemaDiscriminator discriminator;
    @JsonProperty(value="$defs")
    @JsonAlias(value={"definitions"})
    private Map<String, Schema> $defs;
    private String title;
    private String description;
    @JsonSerialize(using=TypeListSerializer.class)
    private List<Type> type;
    private String format;
    @JsonProperty(value="const")
    private Object constValue;
    @JsonProperty(value="enum")
    private List<Object> enumValues;
    private Schema items;
    private Map<String, Schema> properties;
    @JsonProperty(value="defaultValue")
    @JsonAlias(value={"default"})
    private Object defaultValue;
    private Boolean nullable;
    private Boolean deprecated;
    private Boolean readOnly;
    private Boolean writeOnly;
    private List<Object> examples;
    private Object multipleOf;
    private Object maximum;
    private Object minimum;
    private Object exclusiveMaximum;
    private Object exclusiveMinimum;
    private Integer maxLength;
    private Integer minLength;
    private String pattern;
    private Integer maxItems;
    private Integer minItems;
    private Boolean uniqueItems;
    private Schema contains;
    private Integer maxContains;
    private Integer minContains;
    private List<String> required;
    private Schema additionalProperties;
    private List<Schema> oneOf;
    private List<Schema> allOf;
    private List<Schema> anyOf;
    private Schema not;

    public String getTitle() {
        return this.title;
    }

    public Schema setTitle(String title) {
        this.title = title;
        return this;
    }

    public boolean hasTitle() {
        return this.title != null;
    }

    public String getDescription() {
        return this.description;
    }

    public Schema setDescription(String description) {
        this.description = description;
        return this;
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public List<Type> getType() {
        return this.type;
    }

    public Schema setType(List<Type> type) {
        this.type = type;
        return this;
    }

    public Schema addType(Type type) {
        if (this.type == null) {
            this.type = new ArrayList<Type>();
        }
        this.type.add(type);
        return this;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public String getFormat() {
        return this.format;
    }

    public Schema setFormat(String format) {
        this.format = format;
        return this;
    }

    public Object getConstValue() {
        return this.constValue;
    }

    public Schema setConstValue(Object constValue) {
        this.constValue = constValue;
        return this;
    }

    public boolean hasConstValue() {
        return this.constValue != null;
    }

    public List<Object> getEnumValues() {
        return this.enumValues;
    }

    public Schema setEnumValues(List<Object> enumValues) {
        this.enumValues = enumValues;
        return this;
    }

    public boolean isEnum() {
        return this.enumValues != null;
    }

    public Schema getItems() {
        return this.items;
    }

    public Schema setItems(Schema items) {
        this.items = items;
        return this;
    }

    public Map<String, Schema> getProperties() {
        return this.properties;
    }

    public Schema setProperties(Map<String, Schema> properties) {
        this.properties = properties;
        return this;
    }

    public Schema putProperty(String name, Schema property) {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Schema>();
        }
        this.properties.put(name, property);
        return this;
    }

    public boolean hasProperties() {
        return this.properties != null;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Schema setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public Boolean isNullable() {
        return this.nullable;
    }

    public Schema setNullable(boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    public Boolean isDeprecated() {
        return this.deprecated;
    }

    public Schema setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public Schema setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public Boolean isWriteOnly() {
        return this.writeOnly;
    }

    public Schema setWriteOnly(boolean writeOnly) {
        this.writeOnly = writeOnly;
        return this;
    }

    public List<Object> getExamples() {
        return this.examples;
    }

    public Schema setExamples(List<Object> examples) {
        this.examples = examples;
        return this;
    }

    public Object getMultipleOf() {
        return this.multipleOf;
    }

    public Schema setMultipleOf(Object multipleOf) {
        this.multipleOf = multipleOf;
        return this;
    }

    public Object getMaximum() {
        return this.maximum;
    }

    public Schema setMaximum(Object maximum) {
        this.maximum = maximum;
        return this;
    }

    public Object getMinimum() {
        return this.minimum;
    }

    public Schema setMinimum(Object minimum) {
        this.minimum = minimum;
        return this;
    }

    public Object getExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public Schema setExclusiveMaximum(Object exclusiveMaximum) {
        this.exclusiveMaximum = exclusiveMaximum;
        return this;
    }

    public Object getExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public Schema setExclusiveMinimum(Object exclusiveMinimum) {
        this.exclusiveMinimum = exclusiveMinimum;
        return this;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Schema setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public Schema setMinLength(Integer minLength) {
        this.minLength = minLength;
        return this;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Schema setPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public Schema setMaxItems(Integer maxItems) {
        this.maxItems = maxItems;
        return this;
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public Schema setMinItems(Integer minItems) {
        this.minItems = minItems;
        return this;
    }

    public Boolean isUniqueItems() {
        return this.uniqueItems;
    }

    public Schema setUniqueItems(boolean uniqueItems) {
        this.uniqueItems = uniqueItems;
        return this;
    }

    public Integer getMaxContains() {
        return this.maxContains;
    }

    public Schema setMaxContains(Integer maxContains) {
        this.maxContains = maxContains;
        return this;
    }

    public Integer getMinContains() {
        return this.minContains;
    }

    public Schema setMinContains(Integer minContains) {
        this.minContains = minContains;
        return this;
    }

    public Schema getContains() {
        return this.contains;
    }

    public Schema setContains(Schema contains) {
        this.contains = contains;
        return this;
    }

    public List<String> getRequired() {
        return this.required;
    }

    public Schema setRequired(List<String> required) {
        if (this.required != null && !this.required.isEmpty()) {
            this.required.addAll(required);
        } else {
            this.required = required;
        }
        return this;
    }

    public Schema addRequired(String requiredProperty) {
        if (this.required == null) {
            this.required = new ArrayList<String>();
        }
        this.required.add(requiredProperty);
        return this;
    }

    public boolean hasRequired() {
        return this.required != null && !this.required.isEmpty();
    }

    public Schema getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Schema setAdditionalProperties(Schema additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null && !this.additionalProperties.equals(FALSE);
    }

    public List<Schema> getOneOf() {
        return this.oneOf;
    }

    public Schema setOneOf(List<Schema> oneOf) {
        this.oneOf = oneOf;
        return this;
    }

    public Schema addOneOf(Schema one) {
        if (this.oneOf == null) {
            this.oneOf = new ArrayList<Schema>();
        }
        this.oneOf.add(one);
        return this;
    }

    public boolean hasOneOf() {
        return this.oneOf != null;
    }

    public List<Schema> getAllOf() {
        return this.allOf;
    }

    public Schema setAllOf(List<Schema> allOf) {
        this.allOf = allOf;
        this.mergeAllOf();
        return this;
    }

    public Schema addAllOf(Schema one) {
        if (this.allOf == null) {
            this.allOf = new ArrayList<Schema>();
        }
        this.allOf.add(one);
        return this;
    }

    public boolean hasAllOf() {
        return this.allOf != null;
    }

    public void mergeAllOf() {
        List<Schema> thisAllOff = this.allOf;
        thisAllOff.forEach(this::merge);
    }

    public List<Schema> getAnyOf() {
        return this.anyOf;
    }

    public Schema setAnyOf(List<Schema> anyOf) {
        this.anyOf = anyOf;
        return this;
    }

    public Schema addAnyOf(Schema one) {
        if (this.anyOf == null) {
            this.anyOf = new ArrayList<Schema>();
        }
        this.anyOf.add(one);
        return this;
    }

    public boolean hasAnyOf() {
        return this.anyOf != null;
    }

    public String get$schema() {
        return this.$schema;
    }

    public Schema set$schema(String $schema) {
        this.$schema = $schema;
        return this;
    }

    public String get$id() {
        return this.$id;
    }

    public Schema set$id(String $id) {
        this.$id = $id;
        return this;
    }

    public String get$ref() {
        return this.$ref;
    }

    public Schema set$ref(String $ref) {
        this.$ref = $ref;
        return this;
    }

    public boolean has$ref() {
        return this.$ref != null;
    }

    public Map<String, Schema> get$defs() {
        return this.$defs;
    }

    public Schema set$defs(Map<String, Schema> $defs) {
        this.$defs = $defs;
        return this;
    }

    public Schema put$def(String key, Schema $def) {
        this.$defs.put(key, $def);
        return this;
    }

    public boolean has$defs() {
        return this.$defs != null;
    }

    public SchemaDiscriminator getDiscriminator() {
        return this.discriminator;
    }

    public void setDiscriminator(SchemaDiscriminator discriminator) {
        this.discriminator = discriminator;
    }

    public boolean hasDiscriminator() {
        return this.discriminator != null;
    }

    public static Schema string() {
        return new Schema().addType(Type.STRING);
    }

    public static Schema number() {
        return new Schema().addType(Type.NUMBER);
    }

    public static Schema integer() {
        return new Schema().addType(Type.INTEGER);
    }

    public static Schema object() {
        return new Schema().addType(Type.OBJECT);
    }

    public static Schema array() {
        return new Schema().addType(Type.ARRAY);
    }

    public static Schema bool() {
        return new Schema().addType(Type.BOOLEAN);
    }

    public static Schema reference(String id) {
        return new Schema().set$ref(id);
    }

    public Schema getNot() {
        return this.not;
    }

    public Schema setNot(Schema not) {
        this.not = not;
        return this;
    }

    public Schema merge(Schema other) {
        if (other == null) {
            return this;
        }
        if (other.$schema != null) {
            this.$schema = other.$schema;
        }
        if (other.$id != null) {
            this.$id = other.$id;
        }
        if (other.$ref != null) {
            this.$ref = other.$ref;
        }
        if (other.discriminator != null) {
            this.discriminator = this.discriminator == null ? other.discriminator : this.discriminator.merge(other.discriminator);
        }
        if (other.$defs != null) {
            if (this.$defs == null) {
                this.$defs = new HashMap<String, Schema>();
            }
            this.$defs.putAll(other.$defs);
        }
        if (other.title != null) {
            this.title = other.title;
        }
        if (other.description != null) {
            this.description = other.description;
        }
        if (other.type != null) {
            if (this.type == null) {
                this.type = new ArrayList<Type>();
            }
            for (Type typeItem : other.type) {
                if (this.type.contains((Object)typeItem)) continue;
                this.type.add(typeItem);
            }
        }
        if (other.format != null) {
            this.format = other.format;
        }
        if (other.constValue != null) {
            this.constValue = other.constValue;
        }
        if (other.enumValues != null) {
            if (this.enumValues == null) {
                this.enumValues = new ArrayList<Object>();
            }
            for (Object enumItem : other.enumValues) {
                if (this.enumValues.contains(enumItem)) continue;
                this.enumValues.add(enumItem);
            }
        }
        if (other.items != null) {
            if (this.items == null) {
                this.items = other.items;
            } else {
                this.items.merge(other.items);
            }
        }
        if (other.properties != null) {
            other.properties.forEach(this::putProperty);
        }
        if (other.defaultValue != null) {
            this.defaultValue = other.defaultValue;
        }
        if (other.nullable != null) {
            this.nullable = other.nullable;
        }
        if (other.deprecated != null) {
            this.deprecated = other.deprecated;
        }
        if (other.readOnly != null) {
            this.readOnly = other.readOnly;
        }
        if (other.writeOnly != null) {
            this.writeOnly = other.writeOnly;
        }
        if (other.examples != null) {
            if (this.examples == null) {
                this.examples = new ArrayList<Object>();
            }
            for (Object example : other.examples) {
                if (this.examples.contains(example)) continue;
                this.examples.add(example);
            }
        }
        if (other.multipleOf != null) {
            this.multipleOf = other.multipleOf;
        }
        if (other.maximum != null) {
            this.maximum = other.maximum;
        }
        if (other.minimum != null) {
            this.minimum = other.minimum;
        }
        if (other.exclusiveMaximum != null) {
            this.exclusiveMaximum = other.exclusiveMaximum;
        }
        if (other.exclusiveMinimum != null) {
            this.exclusiveMinimum = other.exclusiveMinimum;
        }
        if (other.maxLength != null) {
            this.maxLength = other.maxLength;
        }
        if (other.minLength != null) {
            this.minLength = other.minLength;
        }
        if (other.pattern != null) {
            this.pattern = other.pattern;
        }
        if (other.maxItems != null) {
            this.maxItems = other.maxItems;
        }
        if (other.minItems != null) {
            this.minItems = other.minItems;
        }
        if (other.uniqueItems != null) {
            this.uniqueItems = other.uniqueItems;
        }
        if (other.maxContains != null) {
            this.maxContains = other.maxContains;
        }
        if (other.minContains != null) {
            this.minContains = other.minContains;
        }
        if (other.contains != null) {
            if (this.contains == null) {
                this.contains = other.contains;
            } else {
                this.contains.merge(other.contains);
            }
        }
        if (other.required != null) {
            if (this.required == null) {
                this.required = new ArrayList<String>();
            }
            for (String requiredItem : other.required) {
                if (this.required.contains(requiredItem)) continue;
                this.addRequired(requiredItem);
            }
        }
        if (other.additionalProperties != null) {
            if (this.additionalProperties == null) {
                this.additionalProperties = other.additionalProperties;
            } else {
                this.additionalProperties.merge(other.additionalProperties);
            }
        }
        if (other.oneOf != null) {
            if (this.oneOf == null) {
                this.oneOf = new ArrayList<Schema>();
            }
            this.oneOf.addAll(other.oneOf);
        }
        if (other.allOf != null) {
            if (this.allOf == null) {
                this.allOf = new ArrayList<Schema>();
            }
            this.allOf.addAll(other.allOf);
        }
        if (other.anyOf != null) {
            if (this.anyOf == null) {
                this.anyOf = new ArrayList<Schema>();
            }
            this.anyOf.addAll(other.anyOf);
        }
        if (other.not != null) {
            if (this.not == null) {
                this.not = other.not;
            } else {
                this.not.merge(other.not);
            }
        }
        return this;
    }

    public record SchemaDiscriminator(String propertyName, Map<String, String> mapping) {
        public SchemaDiscriminator merge(SchemaDiscriminator other) {
            String mergedPropertyName = this.propertyName;
            if (other.propertyName != null) {
                mergedPropertyName = other.propertyName;
            }
            Map<String, String> mergedMapping = this.mapping;
            if (other.mapping != null) {
                if (this.mapping == null) {
                    mergedMapping = new HashMap<String, String>();
                }
                mergedMapping.putAll(other.mapping);
            }
            return new SchemaDiscriminator(mergedPropertyName, mergedMapping);
        }
    }

    public static enum Type {
        ARRAY,
        BOOLEAN,
        NULL,
        INTEGER,
        NUMBER,
        OBJECT,
        STRING;


        @JsonValue
        String value() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        @JsonCreator
        static Type fromString(String value) {
            return Type.valueOf(value.toUpperCase(Locale.ENGLISH));
        }
    }
}

