/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jsonschema.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.jsonschema.model.Schema;
import java.io.IOException;
import java.util.List;

@Internal
class TypeListSerializer
extends JsonSerializer<List<Schema.Type>> {
    TypeListSerializer() {
    }

    public void serialize(List<Schema.Type> value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (CollectionUtils.isEmpty(value)) {
            gen.writeNull();
        } else if (value.size() == 1) {
            gen.writeString(value.get(0).value());
        } else {
            gen.writeStartArray();
            for (Schema.Type t : value) {
                gen.writeString(t.value());
            }
            gen.writeEndArray();
        }
    }
}

