/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven.jib;

import com.google.cloud.tools.jib.api.buildplan.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.buildplan.ContainerBuildPlan;
import com.google.cloud.tools.jib.api.buildplan.FileEntriesLayer;
import com.google.cloud.tools.jib.api.buildplan.FileEntry;
import com.google.cloud.tools.jib.api.buildplan.LayerObject;
import com.google.cloud.tools.jib.api.buildplan.Platform;
import com.google.cloud.tools.jib.api.buildplan.Port;
import com.google.cloud.tools.jib.buildplan.UnixPathParser;
import com.google.cloud.tools.jib.maven.extension.JibMavenPluginExtension;
import com.google.cloud.tools.jib.maven.extension.MavenData;
import com.google.cloud.tools.jib.plugins.extension.ExtensionLogger;
import io.micronaut.core.util.StringUtils;
import io.micronaut.maven.core.DockerBuildStrategy;
import io.micronaut.maven.core.MicronautRuntime;
import io.micronaut.maven.jib.JibConfigurationService;
import io.micronaut.maven.services.ApplicationConfigurationService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JibMicronautExtension
implements JibMavenPluginExtension<Void> {
    public static final String DEFAULT_JAVA17_BASE_IMAGE = "eclipse-temurin:17-jre";
    public static final String DEFAULT_JAVA21_BASE_IMAGE = "eclipse-temurin:21-jre";
    private static final String LATEST_TAG = "latest";
    private static final String JDK_TARGET_VERSION = "maven.compiler.target";
    private static final String JDK_RELEASE_VERSION = "maven.compiler.release";
    private static final String JDK_SOURCE_VERSION = "maven.compiler.source";
    private static final Logger LOG = LoggerFactory.getLogger(JibMicronautExtension.class);

    public Optional<Class<Void>> getExtraConfigType() {
        return Optional.empty();
    }

    public ContainerBuildPlan extendContainerBuildPlan(ContainerBuildPlan buildPlan, Map<String, String> properties, Optional<Void> extraConfig, MavenData mavenData, ExtensionLogger logger) {
        ContainerBuildPlan.Builder builder = buildPlan.toBuilder();
        MicronautRuntime runtime = MicronautRuntime.valueOf((String)mavenData.getMavenProject().getProperties().getProperty("micronaut.runtime", "none").toUpperCase());
        JibConfigurationService jibConfigurationService = new JibConfigurationService(mavenData.getMavenProject());
        String baseImage = buildPlan.getBaseImage();
        if (StringUtils.isEmpty((CharSequence)buildPlan.getBaseImage())) {
            baseImage = JibMicronautExtension.determineBaseImage(JibMicronautExtension.getJdkVersion(mavenData.getMavenSession()), runtime.getBuildStrategy());
            builder.setBaseImage(baseImage);
        }
        logger.log(ExtensionLogger.LogLevel.LIFECYCLE, "Using base image: " + baseImage);
        if (buildPlan.getExposedPorts() == null || buildPlan.getExposedPorts().isEmpty()) {
            ApplicationConfigurationService applicationConfigurationService = new ApplicationConfigurationService(mavenData.getMavenProject());
            try {
                int port = Integer.parseInt(applicationConfigurationService.getServerPort());
                if (port > 0) {
                    logger.log(ExtensionLogger.LogLevel.LIFECYCLE, "Exposing port: " + port);
                    builder.addExposedPort(Port.tcp((int)port));
                }
            }
            catch (NumberFormatException e) {
                logger.log(ExtensionLogger.LogLevel.LIFECYCLE, "Dynamically resolved port present. Ensure the port is correctly exposed in the <container> configuration. See https://github.com/GoogleContainerTools/jib/tree/master/jib-maven-plugin#example for an example.");
            }
        }
        if (buildPlan.getPlatforms() == null || buildPlan.getPlatforms().isEmpty()) {
            builder.setPlatforms(Set.of(this.detectPlatform()));
        }
        switch (runtime.getBuildStrategy()) {
            case ORACLE_FUNCTION: {
                List originalLayers = buildPlan.getLayers();
                builder.setLayers(originalLayers.stream().map(JibMicronautExtension::remapLayer).toList());
                List<String> cmd = jibConfigurationService.getArgs();
                if (cmd.isEmpty()) {
                    cmd = Collections.singletonList("io.micronaut.oraclecloud.function.http.HttpFunction::handleRequest");
                }
                builder.setWorkingDirectory(AbsoluteUnixPath.get((String)jibConfigurationService.getWorkingDirectory().orElse("/function"))).setEntrypoint(JibMicronautExtension.buildProjectFnEntrypoint()).setCmd(cmd);
                break;
            }
            case LAMBDA: {
                List entrypoint = buildPlan.getEntrypoint();
                Objects.requireNonNull(entrypoint).set(entrypoint.size() - 1, "io.micronaut.function.aws.runtime.MicronautLambdaRuntime");
                builder.setEntrypoint(entrypoint);
                break;
            }
        }
        return builder.build();
    }

    public static List<String> buildProjectFnEntrypoint() {
        ArrayList<String> entrypoint = new ArrayList<String>(9);
        entrypoint.add("java");
        entrypoint.add("-XX:-UsePerfData");
        entrypoint.add("-XX:+UseSerialGC");
        entrypoint.add("-Xshare:auto");
        entrypoint.add("-Djava.awt.headless=true");
        entrypoint.add("-Djava.library.path=/function/runtime/lib");
        entrypoint.add("-cp");
        entrypoint.add("/function/app/classes:/function/app/libs/*:/function/app/resources:/function/runtime/*");
        entrypoint.add("com.fnproject.fn.runtime.EntryPoint");
        return entrypoint;
    }

    public static String determineProjectFnVersion(String javaVersion) {
        int majorVersion = Integer.parseInt(javaVersion.split("\\.")[0]);
        if (majorVersion <= 21 && majorVersion > 17) {
            return "21-jre";
        }
        if (majorVersion == 17) {
            return "17-jre";
        }
        return LATEST_TAG;
    }

    public static String determineBaseImage(String jdkVersion, DockerBuildStrategy buildStrategy) {
        int javaVersion = Integer.parseInt(jdkVersion);
        return switch (buildStrategy) {
            case DockerBuildStrategy.LAMBDA -> "public.ecr.aws/lambda/java:" + javaVersion;
            default -> javaVersion == 17 ? DEFAULT_JAVA17_BASE_IMAGE : DEFAULT_JAVA21_BASE_IMAGE;
        };
    }

    public static String getJdkVersion(MavenSession session) {
        Optional<String> releaseVersion = JibMicronautExtension.getPropertyValue(session, JDK_RELEASE_VERSION);
        Optional<String> targetVersion = JibMicronautExtension.getPropertyValue(session, JDK_TARGET_VERSION);
        Optional<String> sourceVersion = JibMicronautExtension.getPropertyValue(session, JDK_SOURCE_VERSION);
        Optional<String> jdkVersionOpt = releaseVersion.or(() -> targetVersion).or(() -> sourceVersion);
        String jdkVersion = jdkVersionOpt.orElse("17");
        String propertySource = releaseVersion.isPresent() ? JDK_RELEASE_VERSION : (targetVersion.isPresent() ? JDK_TARGET_VERSION : (sourceVersion.isPresent() ? JDK_SOURCE_VERSION : "default (17)"));
        LOG.info("Using JDK version {} from {}", (Object)jdkVersion, (Object)propertySource);
        return jdkVersion;
    }

    private static Optional<String> getPropertyValue(MavenSession session, String propertName) {
        MojoExecution mojoExecution = new MojoExecution(new MojoDescriptor());
        PluginParameterExpressionEvaluator evaluator = new PluginParameterExpressionEvaluator(session, mojoExecution);
        try {
            return Optional.ofNullable((String)evaluator.evaluate("${" + propertName + "}", String.class));
        }
        catch (ExpressionEvaluationException e) {
            return Optional.empty();
        }
    }

    static LayerObject remapLayer(LayerObject layerObject) {
        FileEntriesLayer originalLayer = (FileEntriesLayer)layerObject;
        FileEntriesLayer.Builder builder = FileEntriesLayer.builder().setName(originalLayer.getName());
        for (FileEntry originalEntry : originalLayer.getEntries()) {
            builder.addEntry(JibMicronautExtension.remapEntry(originalEntry, layerObject.getName()));
        }
        return builder.build();
    }

    static FileEntry remapEntry(FileEntry originalEntry, String layerName) {
        List pathComponents = UnixPathParser.parse((String)originalEntry.getExtractionPath().toString());
        AbsoluteUnixPath newPath = layerName.contains("dependencies") ? AbsoluteUnixPath.get((String)("/function/app/libs/" + (String)pathComponents.get(pathComponents.size() - 1))) : AbsoluteUnixPath.get((String)("/function" + String.valueOf(originalEntry.getExtractionPath())));
        return new FileEntry(originalEntry.getSourceFile(), newPath, originalEntry.getPermissions(), originalEntry.getModificationTime(), originalEntry.getOwnership());
    }

    private Platform detectPlatform() {
        String arch = System.getProperty("os.arch").equals("aarch64") ? "arm64" : "amd64";
        return new Platform(arch, "linux");
    }
}

