/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.async.publisher;

import io.micronaut.core.annotation.Internal;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Internal
public final class DelayedSubscriber<T>
implements Processor<T, T>,
Subscription {
    private static final Object COMPLETE = new Object();
    private boolean wip;
    private Subscription upstream;
    private Subscriber<? super T> downstream;
    private Object completion;
    private long demand;
    private boolean cancel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(Subscriber<? super T> s) {
        s.onSubscribe((Subscription)this);
        DelayedSubscriber delayedSubscriber = this;
        synchronized (delayedSubscriber) {
            this.downstream = s;
        }
        this.work();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSubscribe(Subscription s) {
        DelayedSubscriber delayedSubscriber = this;
        synchronized (delayedSubscriber) {
            this.upstream = s;
        }
        this.work();
    }

    public void onNext(T t) {
        Subscriber<? super T> downstream = this.downstream;
        if (downstream == null) {
            throw new IllegalStateException("onNext before legitimate request");
        }
        downstream.onNext(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Throwable t) {
        DelayedSubscriber delayedSubscriber = this;
        synchronized (delayedSubscriber) {
            this.completion = t;
        }
        this.work();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete() {
        DelayedSubscriber delayedSubscriber = this;
        synchronized (delayedSubscriber) {
            this.completion = COMPLETE;
        }
        this.work();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(long n) {
        DelayedSubscriber delayedSubscriber = this;
        synchronized (delayedSubscriber) {
            this.demand = Math.max(this.demand + n, this.demand);
        }
        this.work();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        DelayedSubscriber delayedSubscriber = this;
        synchronized (delayedSubscriber) {
            this.cancel = true;
        }
        this.work();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void work() {
        boolean holdingWip = false;
        while (true) {
            Object completion = null;
            boolean cancel = false;
            long demand = 0L;
            DelayedSubscriber delayedSubscriber = this;
            synchronized (delayedSubscriber) {
                if (!holdingWip) {
                    if (this.wip) {
                        return;
                    }
                    this.wip = true;
                    holdingWip = true;
                }
                if (this.completion != null && this.downstream != null) {
                    completion = this.completion;
                    this.completion = null;
                } else if (this.demand != 0L && this.upstream != null && this.downstream != null) {
                    demand = this.demand;
                    this.demand = 0L;
                } else if (this.cancel && this.upstream != null) {
                    cancel = true;
                    this.cancel = false;
                } else {
                    this.wip = false;
                    return;
                }
            }
            if (completion != null) {
                if (completion == COMPLETE) {
                    this.downstream.onComplete();
                    continue;
                }
                this.downstream.onError((Throwable)completion);
                continue;
            }
            if (demand != 0L) {
                this.upstream.request(demand);
                continue;
            }
            assert (cancel);
            this.upstream.cancel();
        }
    }
}

