/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.type;

import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.TypeInformationProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ServiceLoader;

@Internal
final class RuntimeTypeInformation {
    private static final Collection<TypeInformationProvider> TYPE_INFORMATION_PROVIDERS;

    RuntimeTypeInformation() {
    }

    static boolean isSpecifiedSingle(AnnotationMetadataProvider annotationMetadata) {
        return TYPE_INFORMATION_PROVIDERS.stream().anyMatch(provider -> provider.isSpecifiedSingle(annotationMetadata));
    }

    static boolean isSingle(Class<?> type) {
        return TYPE_INFORMATION_PROVIDERS.stream().anyMatch(provider -> provider.isSingle(type));
    }

    static boolean isReactive(Class<?> type) {
        return TYPE_INFORMATION_PROVIDERS.stream().anyMatch(provider -> provider.isReactive(type));
    }

    static boolean isCompletable(Class<?> type) {
        return TYPE_INFORMATION_PROVIDERS.stream().anyMatch(provider -> provider.isCompletable(type));
    }

    static <T> boolean isWrapperType(Class<T> type) {
        return TYPE_INFORMATION_PROVIDERS.stream().anyMatch(provider -> provider.isWrapperType(type));
    }

    static {
        ServiceLoader<TypeInformationProvider> loader = ServiceLoader.load(TypeInformationProvider.class);
        ArrayList<TypeInformationProvider> informationProviders = new ArrayList<TypeInformationProvider>(2);
        for (TypeInformationProvider informationProvider : loader) {
            informationProviders.add(informationProvider);
        }
        TYPE_INFORMATION_PROVIDERS = Collections.unmodifiableList(informationProviders);
    }
}

