/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.convert;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.DefaultConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.type.Argument;
import java.util.Optional;
import java.util.function.Function;

public interface ConversionService<Impl extends ConversionService> {
    public static final ConversionService<?> SHARED = new DefaultConversionService();

    public <S, T> Impl addConverter(Class<S> var1, Class<T> var2, Function<S, T> var3);

    public <S, T> Impl addConverter(Class<S> var1, Class<T> var2, TypeConverter<S, T> var3);

    public <T> Optional<T> convert(Object var1, Class<T> var2, ConversionContext var3);

    public <S, T> boolean canConvert(Class<S> var1, Class<T> var2);

    default public <T> Optional<T> convert(Object object, Class<T> targetType) {
        return this.convert(object, targetType, ConversionContext.DEFAULT);
    }

    default public <T> Optional<T> convert(Object object, Argument<T> targetType) {
        return this.convert(object, targetType.getType(), ConversionContext.of(targetType));
    }

    default public <T> Optional<T> convert(Object object, ArgumentConversionContext<T> context) {
        return this.convert(object, context.getArgument().getType(), context);
    }

    @Nullable
    default public <T> T convertRequired(@Nullable Object value, Class<T> type) {
        if (value == null) {
            return null;
        }
        Argument<T> arg = Argument.of(type);
        return this.convertRequired(value, arg);
    }

    @Nullable
    default public <T> T convertRequired(@Nullable Object value, Argument<T> argument) {
        ArgumentConversionContext context = ConversionContext.of(argument);
        return this.convert(value, argument.getType(), context).orElseThrow(() -> {
            Optional<ConversionError> lastError = context.getLastError();
            if (lastError.isPresent()) {
                return new ConversionErrorException(context.getArgument(), lastError.get());
            }
            return new ConversionErrorException(context.getArgument(), new IllegalArgumentException("Cannot convert type [" + value.getClass() + "] to target type: " + argument.getType() + ". Considering defining a TypeConverter bean to handle this case."));
        });
    }
}

