/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Primary;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.ssl.ClientSslConfiguration;
import io.micronaut.http.ssl.SslConfiguration;
import io.micronaut.runtime.ApplicationConfiguration;
import jakarta.inject.Inject;

@ConfigurationProperties(value="micronaut.http.client")
@BootstrapContextCompatible
@Primary
public class DefaultHttpClientConfiguration
extends HttpClientConfiguration {
    public static final String PREFIX = "micronaut.http.client";
    private final DefaultConnectionPoolConfiguration connectionPoolConfiguration;
    private final DefaultWebSocketCompressionConfiguration webSocketCompressionConfiguration;

    public DefaultHttpClientConfiguration() {
        this.connectionPoolConfiguration = new DefaultConnectionPoolConfiguration();
        this.webSocketCompressionConfiguration = new DefaultWebSocketCompressionConfiguration();
    }

    @Deprecated(since="4.3.0")
    public DefaultHttpClientConfiguration(DefaultConnectionPoolConfiguration connectionPoolConfiguration, ApplicationConfiguration applicationConfiguration) {
        this(connectionPoolConfiguration, new DefaultWebSocketCompressionConfiguration(), applicationConfiguration);
    }

    @Inject
    public DefaultHttpClientConfiguration(DefaultConnectionPoolConfiguration connectionPoolConfiguration, DefaultWebSocketCompressionConfiguration webSocketCompressionConfiguration, ApplicationConfiguration applicationConfiguration) {
        super(applicationConfiguration);
        this.connectionPoolConfiguration = connectionPoolConfiguration;
        this.webSocketCompressionConfiguration = webSocketCompressionConfiguration;
    }

    @Override
    public HttpClientConfiguration.ConnectionPoolConfiguration getConnectionPoolConfiguration() {
        return this.connectionPoolConfiguration;
    }

    @Override
    public HttpClientConfiguration.WebSocketCompressionConfiguration getWebSocketCompressionConfiguration() {
        return this.webSocketCompressionConfiguration;
    }

    @Inject
    public void setClientSslConfiguration(@Nullable ClientSslConfiguration sslConfiguration) {
        if (sslConfiguration != null) {
            super.setSslConfiguration((SslConfiguration)sslConfiguration);
        }
    }

    @ConfigurationProperties(value="pool")
    @BootstrapContextCompatible
    @Primary
    public static class DefaultConnectionPoolConfiguration
    extends HttpClientConfiguration.ConnectionPoolConfiguration {
    }

    @ConfigurationProperties(value="ws.compression")
    @BootstrapContextCompatible
    @Primary
    public static class DefaultWebSocketCompressionConfiguration
    extends HttpClientConfiguration.WebSocketCompressionConfiguration {
    }
}

