/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.encoders;

import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.Writable;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.netty.NettyMutableHttpResponse;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.runtime.http.codec.TextPlainCodec;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
@ChannelHandler.Sharable
public class HttpResponseEncoder
extends MessageToMessageEncoder<MutableHttpResponse<?>> {
    public static final String ID = "micronaut-http-encoder";
    private static final Logger LOG = LoggerFactory.getLogger(HttpResponseEncoder.class);
    private final MediaTypeCodecRegistry mediaTypeCodecRegistry;
    private final HttpServerConfiguration serverConfiguration;

    public HttpResponseEncoder(MediaTypeCodecRegistry mediaTypeCodecRegistry, HttpServerConfiguration serverConfiguration) {
        this.mediaTypeCodecRegistry = mediaTypeCodecRegistry;
        this.serverConfiguration = serverConfiguration;
    }

    protected void encode(ChannelHandlerContext context, MutableHttpResponse<?> response, List<Object> out) {
        Optional specifiedMediaType = response.getContentType();
        MediaType responseMediaType = specifiedMediaType.orElse(MediaType.APPLICATION_JSON_TYPE);
        this.applyConfiguredHeaders(response.getHeaders());
        Optional responseBody = response.getBody();
        if (responseBody.isPresent()) {
            MediaTypeCodec codec;
            Object registeredCodec;
            Object body = responseBody.get();
            if (specifiedMediaType.isPresent() && ((Optional)(registeredCodec = this.mediaTypeCodecRegistry.findCodec(responseMediaType, body.getClass()))).isPresent()) {
                codec = (MediaTypeCodec)((Optional)registeredCodec).get();
                response = this.encodeBodyWithCodec(response, body, codec, responseMediaType, context);
            }
            if (((Optional)(registeredCodec = this.mediaTypeCodecRegistry.findCodec(MediaType.APPLICATION_JSON_TYPE, body.getClass()))).isPresent()) {
                codec = (MediaTypeCodec)((Optional)registeredCodec).get();
                response = this.encodeBodyWithCodec(response, body, codec, responseMediaType, context);
            }
            TextPlainCodec defaultCodec = new TextPlainCodec(this.serverConfiguration.getDefaultCharset());
            response = this.encodeBodyWithCodec(response, body, (MediaTypeCodec)defaultCodec, responseMediaType, context);
        }
        if (response instanceof NettyMutableHttpResponse) {
            out.add(((NettyMutableHttpResponse)response).getNativeResponse());
        } else {
            DefaultHttpHeaders nettyHeaders = new DefaultHttpHeaders();
            for (Map.Entry header : response.getHeaders()) {
                nettyHeaders.add((String)header.getKey(), (Iterable)header.getValue());
            }
            Object b = response.getBody().orElse(null);
            ByteBuf body = b instanceof ByteBuf ? (ByteBuf)b : Unpooled.buffer((int)0);
            DefaultFullHttpResponse nettyResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)response.status().getCode(), (String)response.status().getReason()), body, (HttpHeaders)nettyHeaders, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
            out.add(nettyResponse);
        }
    }

    private void applyConfiguredHeaders(MutableHttpHeaders headers) {
        if (this.serverConfiguration.isDateHeader() && !headers.contains("Date")) {
            headers.date(LocalDateTime.now());
        }
        this.serverConfiguration.getServerHeader().ifPresent(server -> {
            if (!headers.contains("Server")) {
                headers.add((CharSequence)HttpHeaderNames.SERVER, (CharSequence)server);
            }
        });
    }

    private MutableHttpResponse<?> encodeBodyWithCodec(MutableHttpResponse<?> response, Object body, MediaTypeCodec codec, MediaType mediaType, ChannelHandlerContext context) {
        ByteBuf byteBuf = this.encodeBodyAsByteBuf(body, codec, context, response);
        int len = byteBuf.readableBytes();
        MutableHttpHeaders headers = response.getHeaders();
        if (!headers.contains("Content-Type")) {
            headers.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)mediaType);
        }
        headers.remove((CharSequence)"Content-Length");
        headers.add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)String.valueOf(len));
        this.setBodyContent(response, byteBuf);
        return response;
    }

    private MutableHttpResponse<?> setBodyContent(MutableHttpResponse response, Object bodyContent) {
        MutableHttpResponse res = response.body(bodyContent);
        return res;
    }

    private ByteBuf encodeBodyAsByteBuf(Object body, MediaTypeCodec codec, ChannelHandlerContext context, MutableHttpResponse response) {
        ByteBuf byteBuf;
        if (body instanceof ByteBuf) {
            byteBuf = (ByteBuf)body;
        } else if (body instanceof io.micronaut.core.io.buffer.ByteBuffer) {
            io.micronaut.core.io.buffer.ByteBuffer byteBuffer = (io.micronaut.core.io.buffer.ByteBuffer)body;
            Object nativeBuffer = byteBuffer.asNativeBuffer();
            byteBuf = nativeBuffer instanceof ByteBuf ? (ByteBuf)nativeBuffer : Unpooled.wrappedBuffer((ByteBuffer)byteBuffer.asNioBuffer());
        } else if (body instanceof byte[]) {
            byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])body));
        } else if (body instanceof Writable) {
            byteBuf = context.alloc().ioBuffer(128);
            ByteBufOutputStream outputStream = new ByteBufOutputStream(byteBuf);
            Writable writable = (Writable)body;
            try {
                writable.writeTo((OutputStream)outputStream, response.getCharacterEncoding());
            }
            catch (IOException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(e.getMessage());
                }
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Encoding emitted response object [{}] using codec: {}", body, (Object)codec);
            }
            byteBuf = (ByteBuf)codec.encode(body, (ByteBufferFactory)new NettyByteBufferFactory(context.alloc())).asNativeBuffer();
        }
        return byteBuf;
    }
}

