/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.codec.CodecConfiguration;
import io.micronaut.http.server.netty.jackson.JsonViewCodecResolver;
import io.micronaut.jackson.JacksonConfiguration;
import io.micronaut.jackson.codec.JsonMediaTypeCodec;
import io.micronaut.runtime.ApplicationConfiguration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Named;
import javax.inject.Singleton;

@Requirements(value={@Requires(beans={JacksonConfiguration.class}), @Requires(property="jackson.json-view.enabled")})
@Singleton
@Internal
@Primary
public class JsonViewMediaTypeCodecFactory
implements JsonViewCodecResolver {
    private final ObjectMapper objectMapper;
    private final ApplicationConfiguration applicationConfiguration;
    private final CodecConfiguration codecConfiguration;
    private final Map<Class<?>, JsonMediaTypeCodec> jsonViewCodecs = new ConcurrentHashMap(5);

    protected JsonViewMediaTypeCodecFactory(ObjectMapper objectMapper, ApplicationConfiguration applicationConfiguration, @Named(value="json") @Nullable CodecConfiguration codecConfiguration) {
        this.objectMapper = objectMapper;
        this.applicationConfiguration = applicationConfiguration;
        this.codecConfiguration = codecConfiguration;
    }

    @Override
    @NonNull
    public JsonMediaTypeCodec resolveJsonViewCodec(@NonNull Class<?> viewClass) {
        ArgumentUtils.requireNonNull((String)"viewClass", viewClass);
        JsonMediaTypeCodec codec = this.jsonViewCodecs.get(viewClass);
        if (codec == null) {
            ObjectMapper viewMapper = this.objectMapper.copy();
            viewMapper.setConfig(viewMapper.getSerializationConfig().withView(viewClass));
            codec = new JsonMediaTypeCodec(viewMapper, this.applicationConfiguration, this.codecConfiguration);
            this.jsonViewCodecs.put(viewClass, codec);
        }
        return codec;
    }
}

