/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.simple;

import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.http.MutableHttpHeaders;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class SimpleHttpHeaders
implements MutableHttpHeaders {
    private final Map<String, String> headers;
    private final ConversionService conversionService;

    public SimpleHttpHeaders(Map<String, String> headers, ConversionService conversionService) {
        this.headers = headers;
        this.conversionService = conversionService;
    }

    public SimpleHttpHeaders(ConversionService conversionService) {
        this(new LinkedHashMap<String, String>(), conversionService);
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        String value = this.headers.get(name.toString());
        if (value != null) {
            return this.conversionService.convert((Object)value, conversionContext);
        }
        return Optional.empty();
    }

    public List<String> getAll(CharSequence name) {
        return Collections.singletonList(this.headers.get(name.toString()));
    }

    public Set<String> names() {
        return this.headers.keySet();
    }

    public Collection<List<String>> values() {
        Set<String> names = this.names();
        ArrayList<List<String>> values = new ArrayList<List<String>>();
        for (String name : names) {
            values.add(this.getAll(name));
        }
        return Collections.unmodifiableList(values);
    }

    public String get(CharSequence name) {
        return this.headers.get(name.toString());
    }

    @Override
    public MutableHttpHeaders add(CharSequence header, CharSequence value) {
        this.headers.put(header.toString(), value == null ? null : value.toString());
        return this;
    }

    @Override
    public MutableHttpHeaders remove(CharSequence header) {
        this.headers.remove(header.toString());
        return this;
    }
}

