/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.MediaType;
import io.micronaut.http.body.ChunkedMessageBodyReader;
import io.micronaut.http.body.TypedMessageBodyHandler;
import io.micronaut.http.codec.CodecException;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Singleton
@BootstrapContextCompatible
@Internal
final class ByteArrayBodyHandler
implements TypedMessageBodyHandler<byte[]>,
ChunkedMessageBodyReader<byte[]> {
    ByteArrayBodyHandler() {
    }

    @Override
    public Argument<byte[]> getType() {
        return Argument.of(byte[].class);
    }

    @Override
    public byte[] read(Argument<byte[]> type, MediaType mediaType, Headers httpHeaders, ByteBuffer<?> byteBuffer) throws CodecException {
        return ByteArrayBodyHandler.read0(byteBuffer);
    }

    private static byte[] read0(ByteBuffer<?> byteBuffer) {
        byte[] arr = byteBuffer.toByteArray();
        if (byteBuffer instanceof ReferenceCounted) {
            ReferenceCounted rc = (ReferenceCounted)byteBuffer;
            rc.release();
        }
        return arr;
    }

    @Override
    public byte[] read(Argument<byte[]> type, MediaType mediaType, Headers httpHeaders, InputStream inputStream) throws CodecException {
        try {
            return inputStream.readAllBytes();
        }
        catch (IOException e) {
            throw new CodecException("Failed to read InputStream", e);
        }
    }

    @Override
    public void writeTo(Argument<byte[]> type, MediaType mediaType, byte[] object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
        ByteArrayBodyHandler.addContentType(outgoingHeaders, mediaType);
        try {
            outputStream.write(object);
        }
        catch (IOException e) {
            throw new CodecException("Failed to write OutputStream", e);
        }
    }

    @Override
    public ByteBuffer<?> writeTo(Argument<byte[]> type, MediaType mediaType, byte[] object, MutableHeaders outgoingHeaders, ByteBufferFactory<?, ?> bufferFactory) throws CodecException {
        ByteArrayBodyHandler.addContentType(outgoingHeaders, mediaType);
        return bufferFactory.wrap(object);
    }

    @Override
    public Publisher<byte[]> readChunked(Argument<byte[]> type, MediaType mediaType, Headers httpHeaders, Publisher<ByteBuffer<?>> input) {
        return Flux.from(input).map(ByteArrayBodyHandler::read0);
    }

    private static void addContentType(MutableHeaders outgoingHeaders, @Nullable MediaType mediaType) {
        if (mediaType != null) {
            outgoingHeaders.setIfMissing((CharSequence)"Content-Type", (CharSequence)mediaType);
        }
    }
}

