/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.hateoas;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.ReflectiveAccess;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.OptionalMultiValues;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.hateoas.Link;
import io.micronaut.http.hateoas.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Produces(value={"application/hal+json"})
@Introspected
public abstract class AbstractResource<Impl extends AbstractResource<Impl>>
implements Resource {
    private final Map<CharSequence, List<Link>> linkMap = new LinkedHashMap<CharSequence, List<Link>>(1);
    private final Map<CharSequence, List<Resource>> embeddedMap = new LinkedHashMap<CharSequence, List<Resource>>(1);

    public Impl link(@Nullable CharSequence ref, @Nullable Link link) {
        if (StringUtils.isNotEmpty((CharSequence)ref) && link != null) {
            List links = this.linkMap.computeIfAbsent(ref, charSequence -> new ArrayList());
            links.add(link);
        }
        return (Impl)this;
    }

    public Impl link(@Nullable CharSequence ref, @Nullable String link) {
        if (StringUtils.isNotEmpty((CharSequence)ref) && link != null) {
            List links = this.linkMap.computeIfAbsent(ref, charSequence -> new ArrayList());
            links.add(Link.of(link));
        }
        return (Impl)this;
    }

    public Impl embedded(CharSequence ref, Resource resource) {
        if (StringUtils.isNotEmpty((CharSequence)ref) && resource != null) {
            List resources = this.embeddedMap.computeIfAbsent(ref, charSequence -> new ArrayList());
            resources.add(resource);
        }
        return (Impl)this;
    }

    public Impl embedded(CharSequence ref, Resource ... resource) {
        if (StringUtils.isNotEmpty((CharSequence)ref) && resource != null) {
            List resources = this.embeddedMap.computeIfAbsent(ref, charSequence -> new ArrayList());
            resources.addAll(Arrays.asList(resource));
        }
        return (Impl)this;
    }

    public Impl embedded(CharSequence ref, List<Resource> resourceList) {
        if (StringUtils.isNotEmpty((CharSequence)ref) && resourceList != null) {
            List resources = this.embeddedMap.computeIfAbsent(ref, charSequence -> new ArrayList());
            resources.addAll(resourceList);
        }
        return (Impl)this;
    }

    @JsonProperty(value="_links")
    public OptionalMultiValues<Link> getLinks() {
        return OptionalMultiValues.of(this.linkMap);
    }

    @JsonProperty(value="_embedded")
    public OptionalMultiValues<Resource> getEmbedded() {
        return OptionalMultiValues.of(this.embeddedMap);
    }

    @Internal
    @ReflectiveAccess
    @JsonProperty(value="_links")
    public final void setLinks(Map<String, Object> links) {
        for (Map.Entry<String, Object> entry : links.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                Map linkMap = (Map)value;
                this.link(name, linkMap);
                continue;
            }
            if (!(value instanceof Collection)) continue;
            Collection collection = (Collection)value;
            for (Object o : collection) {
                if (!(o instanceof Map)) continue;
                Map aMap = (Map)o;
                this.link(name, aMap);
            }
        }
    }

    @Internal
    @ReflectiveAccess
    @JsonProperty(value="_embedded")
    public final void setEmbedded(Map<String, List<Resource>> embedded) {
        this.embeddedMap.putAll(embedded);
    }

    private void link(String name, Map<String, Object> linkMap) {
        ConvertibleValues values = ConvertibleValues.of(linkMap);
        Optional uri = values.get(Link.HREF, String.class);
        uri.ifPresent(uri1 -> {
            Link.Builder link = Link.build(uri1);
            values.get((CharSequence)"templated", Boolean.class).ifPresent(link::templated);
            values.get((CharSequence)"hreflang", String.class).ifPresent(link::hreflang);
            values.get((CharSequence)"title", String.class).ifPresent(link::title);
            values.get((CharSequence)"profile", String.class).ifPresent(link::profile);
            values.get((CharSequence)"deprecation", String.class).ifPresent(link::deprecation);
            this.link((CharSequence)name, link.build());
        });
    }
}

