/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.writer;

import io.micronaut.asm.ClassVisitor;
import io.micronaut.asm.ClassWriter;
import io.micronaut.asm.MethodVisitor;
import io.micronaut.asm.Opcodes;
import io.micronaut.asm.Type;
import io.micronaut.asm.commons.GeneratorAdapter;
import io.micronaut.asm.commons.Method;
import io.micronaut.context.AbstractExecutableMethod;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.annotation.AnnotationMetadataReference;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;
import io.micronaut.inject.writer.AbstractAnnotationMetadataWriter;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;

@Internal
public class ExecutableMethodWriter
extends AbstractAnnotationMetadataWriter
implements Opcodes {
    public static final String FIELD_PARENT = "$parent";
    protected static final Method METHOD_INVOKE_INTERNAL = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(AbstractExecutableMethod.class, (String)"invokeInternal", (Class[])new Class[]{Object.class, Object[].class}));
    protected static final Method METHOD_IS_ABSTRACT = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(ExecutableMethod.class, (String)"isAbstract", (Class[])new Class[0]));
    protected static final Method METHOD_IS_SUSPEND = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(ExecutableMethod.class, (String)"isSuspend", (Class[])new Class[0]));
    protected static final Method METHOD_GET_TARGET = Method.getMethod((String)"java.lang.reflect.Method resolveTargetMethod()");
    private static final Type TYPE_REFLECTION_UTILS = Type.getType(ReflectionUtils.class);
    private static final Method METHOD_GET_REQUIRED_METHOD = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(ReflectionUtils.class, (String)"getRequiredMethod", (Class[])new Class[]{Class.class, String.class, Class[].class}));
    protected final Type methodType;
    private final ClassWriter classWriter = new ClassWriter(3);
    private final String className;
    private final String internalName;
    private final String beanFullClassName;
    private final String methodProxyShortName;
    private final boolean isInterface;
    private final boolean isAbstract;
    private final boolean isSuspend;
    private String outerClassName = null;
    private boolean isStatic = false;

    public ExecutableMethodWriter(String beanFullClassName, String methodClassName, String methodProxyShortName, boolean isInterface, boolean isSuspend, AnnotationMetadata annotationMetadata) {
        super(methodClassName, annotationMetadata, true);
        this.beanFullClassName = beanFullClassName;
        this.methodProxyShortName = methodProxyShortName;
        this.className = methodClassName;
        this.internalName = ExecutableMethodWriter.getInternalName(methodClassName);
        this.methodType = ExecutableMethodWriter.getObjectType(methodClassName);
        this.isInterface = isInterface;
        this.isAbstract = isInterface;
        this.isSuspend = isSuspend;
    }

    public ExecutableMethodWriter(String beanFullClassName, String methodClassName, String methodProxyShortName, boolean isInterface, boolean isAbstract, boolean isSuspend, AnnotationMetadata annotationMetadata) {
        super(methodClassName, annotationMetadata, true);
        this.beanFullClassName = beanFullClassName;
        this.methodProxyShortName = methodProxyShortName;
        this.className = methodClassName;
        this.internalName = ExecutableMethodWriter.getInternalName(methodClassName);
        this.methodType = ExecutableMethodWriter.getObjectType(methodClassName);
        this.isInterface = isInterface;
        this.isAbstract = isInterface || isAbstract;
        this.isSuspend = isSuspend;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isSuspend() {
        return this.isSuspend;
    }

    public String getClassName() {
        return this.className;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public void makeInner(String outerName, ClassWriter outerClassWriter) {
        outerClassWriter.visitInnerClass(this.internalName, ExecutableMethodWriter.getInternalName(outerName), this.methodProxyShortName.substring(1), 0);
        this.classWriter.visitOuterClass(ExecutableMethodWriter.getInternalName(outerName), null, null);
        if (!this.isStatic) {
            this.classWriter.visitField(18, FIELD_PARENT, ExecutableMethodWriter.getTypeDescriptor(outerName), null, null);
        }
        this.outerClassName = outerName;
    }

    public void visitMethod(Object declaringType, Object returnType, Object genericReturnType, Map<String, Object> returnTypeGenericTypes, String methodName, Map<String, Object> argumentTypes, Map<String, Object> genericArgumentTypes, Map<String, AnnotationMetadata> argumentAnnotationMetadata, Map<String, Map<String, Object>> genericTypes) {
        String constructorDescriptor;
        GeneratorAdapter executorMethodConstructor;
        boolean hasOuter;
        Type declaringTypeObject = ExecutableMethodWriter.getTypeReference(declaringType);
        boolean hasArgs = !argumentTypes.isEmpty();
        List<Object> argumentTypeClasses = hasArgs ? argumentTypes.values() : Collections.emptyList();
        int modifiers = this.isStatic ? 4104 : 4096;
        this.classWriter.visit(52, modifiers, this.internalName, null, Type.getInternalName(AbstractExecutableMethod.class), null);
        if (!(this.annotationMetadata instanceof AnnotationMetadataReference)) {
            this.writeAnnotationMetadataStaticInitializer(this.classWriter);
        }
        this.writeGetAnnotationMetadataMethod(this.classWriter);
        boolean bl = hasOuter = this.outerClassName != null && !this.isStatic;
        if (hasOuter) {
            executorMethodConstructor = this.startConstructor((ClassVisitor)this.classWriter, this.outerClassName);
            constructorDescriptor = ExecutableMethodWriter.getConstructorDescriptor(this.outerClassName);
        } else {
            executorMethodConstructor = this.startConstructor((ClassVisitor)this.classWriter);
            constructorDescriptor = "()V";
        }
        GeneratorAdapter constructorWriter = new GeneratorAdapter((MethodVisitor)executorMethodConstructor, 1, "<init>", constructorDescriptor);
        if (hasOuter) {
            constructorWriter.loadThis();
            constructorWriter.loadArg(0);
            constructorWriter.putField(this.methodType, FIELD_PARENT, ExecutableMethodWriter.getObjectType(this.outerClassName));
        }
        constructorWriter.loadThis();
        constructorWriter.loadThis();
        constructorWriter.push(declaringTypeObject);
        constructorWriter.push(methodName);
        if (genericReturnType instanceof Class && ((Class)genericReturnType).isPrimitive()) {
            Class javaType = (Class)genericReturnType;
            String constantName = javaType.getName().toUpperCase(Locale.ENGLISH);
            Type type = Type.getType(Argument.class);
            constructorWriter.getStatic(type, constantName, type);
        } else {
            ExecutableMethodWriter.buildArgumentWithGenerics(constructorWriter, methodName, Collections.singletonMap(genericReturnType, returnTypeGenericTypes));
        }
        if (hasArgs) {
            ExecutableMethodWriter.pushBuildArgumentsForMethod(ExecutableMethodWriter.getTypeReferenceForName(this.getClassName(), new String[0]), this.classWriter, constructorWriter, genericArgumentTypes, argumentAnnotationMetadata, genericTypes, this.loadTypeMethods);
            for (AnnotationMetadata value : argumentAnnotationMetadata.values()) {
                DefaultAnnotationMetadata.contributeDefaults(this.annotationMetadata, value);
            }
            this.invokeConstructor((MethodVisitor)executorMethodConstructor, AbstractExecutableMethod.class, Class.class, String.class, Argument.class, Argument[].class);
        } else {
            this.invokeConstructor((MethodVisitor)executorMethodConstructor, AbstractExecutableMethod.class, Class.class, String.class, Argument.class);
        }
        constructorWriter.visitInsn(177);
        constructorWriter.visitMaxs(13, 1);
        GeneratorAdapter isAbstractMethod = new GeneratorAdapter(this.classWriter.visitMethod(17, METHOD_IS_ABSTRACT.getName(), METHOD_IS_ABSTRACT.getDescriptor(), null, null), 1, METHOD_IS_ABSTRACT.getName(), METHOD_IS_ABSTRACT.getDescriptor());
        isAbstractMethod.push(this.isAbstract());
        isAbstractMethod.returnValue();
        isAbstractMethod.visitMaxs(1, 1);
        isAbstractMethod.endMethod();
        GeneratorAdapter isSuspendMethod = new GeneratorAdapter(this.classWriter.visitMethod(17, METHOD_IS_SUSPEND.getName(), METHOD_IS_SUSPEND.getDescriptor(), null, null), 1, METHOD_IS_SUSPEND.getName(), METHOD_IS_SUSPEND.getDescriptor());
        isSuspendMethod.push(this.isSuspend());
        isSuspendMethod.returnValue();
        isSuspendMethod.visitMaxs(1, 1);
        isSuspendMethod.endMethod();
        String invokeDescriptor = METHOD_INVOKE_INTERNAL.getDescriptor();
        String invokeInternalName = METHOD_INVOKE_INTERNAL.getName();
        GeneratorAdapter invokeMethod = new GeneratorAdapter(this.classWriter.visitMethod(1, invokeInternalName, invokeDescriptor, null, null), 1, invokeInternalName, invokeDescriptor);
        this.buildInvokeMethod(declaringTypeObject, methodName, returnType, argumentTypeClasses, invokeMethod);
        this.buildResolveTargetMethod(methodName, declaringTypeObject, hasArgs, argumentTypeClasses);
        for (GeneratorAdapter method : this.loadTypeMethods.values()) {
            method.visitMaxs(3, 1);
            method.visitEnd();
        }
    }

    public void makeStaticInner(String parentInternalName, ClassWriter classWriter) {
        this.isStatic = true;
        this.makeInner(parentInternalName, classWriter);
    }

    @Override
    public void accept(ClassWriterOutputVisitor classWriterOutputVisitor) throws IOException {
        try (OutputStream outputStream = classWriterOutputVisitor.visitClass(this.className);){
            outputStream.write(this.classWriter.toByteArray());
        }
    }

    @Override
    @Nonnull
    protected final GeneratorAdapter beginAnnotationMetadataMethod(ClassWriter classWriter) {
        return this.startProtectedMethod(classWriter, "resolveAnnotationMetadata", AnnotationMetadata.class.getName(), new String[0]);
    }

    protected void buildInvokeMethod(Type declaringTypeObject, String methodName, Object returnType, Collection<Object> argumentTypes, GeneratorAdapter invokeMethodVisitor) {
        String methodDescriptor;
        boolean hasArgs;
        Type returnTypeObject = ExecutableMethodWriter.getTypeReference(returnType);
        invokeMethodVisitor.visitVarInsn(25, 1);
        ExecutableMethodWriter.pushCastToType((MethodVisitor)invokeMethodVisitor, this.beanFullClassName);
        boolean bl = hasArgs = !argumentTypes.isEmpty();
        if (hasArgs) {
            methodDescriptor = ExecutableMethodWriter.getMethodDescriptor(returnType, argumentTypes);
            int argCount = argumentTypes.size();
            Iterator<Object> argIterator = argumentTypes.iterator();
            for (int i = 0; i < argCount; ++i) {
                invokeMethodVisitor.visitVarInsn(25, 2);
                invokeMethodVisitor.push(i);
                invokeMethodVisitor.visitInsn(50);
                ExecutableMethodWriter.pushCastToType((MethodVisitor)invokeMethodVisitor, argIterator.next());
            }
        } else {
            methodDescriptor = ExecutableMethodWriter.getMethodDescriptor(returnType, Collections.emptyList());
        }
        invokeMethodVisitor.visitMethodInsn(this.isInterface ? 185 : 182, declaringTypeObject.getInternalName(), methodName, methodDescriptor, this.isInterface);
        if (returnTypeObject.equals((Object)Type.VOID_TYPE)) {
            invokeMethodVisitor.visitInsn(1);
        } else {
            ExecutableMethodWriter.pushBoxPrimitiveIfNecessary(returnType, (MethodVisitor)invokeMethodVisitor);
        }
        invokeMethodVisitor.visitInsn(176);
        invokeMethodVisitor.visitMaxs(13, 1);
        invokeMethodVisitor.visitEnd();
    }

    private void buildResolveTargetMethod(String methodName, Type declaringTypeObject, boolean hasArgs, Collection<Object> argumentTypeClasses) {
        String targetMethodInternalName = METHOD_GET_TARGET.getName();
        String targetMethodDescriptor = METHOD_GET_TARGET.getDescriptor();
        GeneratorAdapter getTargetMethod = new GeneratorAdapter(this.classWriter.visitMethod(17, targetMethodInternalName, targetMethodDescriptor, null, null), 17, targetMethodInternalName, targetMethodDescriptor);
        getTargetMethod.push(declaringTypeObject);
        getTargetMethod.push(methodName);
        if (hasArgs) {
            int len = argumentTypeClasses.size();
            Iterator<Object> iter = argumentTypeClasses.iterator();
            ExecutableMethodWriter.pushNewArray(getTargetMethod, Class.class, len);
            for (int i = 0; i < len; ++i) {
                Object type = iter.next();
                ExecutableMethodWriter.pushStoreInArray(getTargetMethod, i, len, () -> getTargetMethod.push(ExecutableMethodWriter.getTypeReference(type)));
            }
        } else {
            getTargetMethod.getStatic(TYPE_REFLECTION_UTILS, "EMPTY_CLASS_ARRAY", Type.getType(Class[].class));
        }
        getTargetMethod.invokeStatic(TYPE_REFLECTION_UTILS, METHOD_GET_REQUIRED_METHOD);
        getTargetMethod.returnValue();
        getTargetMethod.visitMaxs(1, 1);
        getTargetMethod.endMethod();
    }
}

