/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.asm.ClassVisitor;
import io.micronaut.asm.ClassWriter;
import io.micronaut.asm.Label;
import io.micronaut.asm.MethodVisitor;
import io.micronaut.asm.Type;
import io.micronaut.asm.commons.GeneratorAdapter;
import io.micronaut.asm.commons.Method;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.annotation.AnnotationMetadataReference;
import io.micronaut.inject.annotation.AnnotationMetadataSupport;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.writer.AbstractClassFileWriter;
import io.micronaut.inject.writer.ClassGenerationException;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Internal
public class AnnotationMetadataWriter
extends AbstractClassFileWriter {
    private static final Type TYPE_DEFAULT_ANNOTATION_METADATA = Type.getType(DefaultAnnotationMetadata.class);
    private static final Type TYPE_DEFAULT_ANNOTATION_METADATA_HIERARCHY = Type.getType(AnnotationMetadataHierarchy.class);
    private static final Type TYPE_ANNOTATION_CLASS_VALUE = Type.getType(AnnotationClassValue.class);
    private static final Method METHOD_MAP_OF = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(AnnotationUtil.class, (String)"internMapOf", (Class[])new Class[]{Object[].class}));
    private static final Method METHOD_LIST_OF = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(AnnotationUtil.class, (String)"internListOf", (Class[])new Class[]{Object[].class}));
    private static final Method METHOD_REGISTER_ANNOTATION_DEFAULTS = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(DefaultAnnotationMetadata.class, (String)"registerAnnotationDefaults", (Class[])new Class[]{AnnotationClassValue.class, Map.class}));
    private static final Method METHOD_REGISTER_ANNOTATION_TYPE = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(DefaultAnnotationMetadata.class, (String)"registerAnnotationType", (Class[])new Class[]{AnnotationClassValue.class}));
    private static final Method CONSTRUCTOR_ANNOTATION_METADATA = Method.getMethod((Constructor)ReflectionUtils.getRequiredInternalConstructor(DefaultAnnotationMetadata.class, (Class[])new Class[]{Map.class, Map.class, Map.class, Map.class, Map.class}));
    private static final Method CONSTRUCTOR_ANNOTATION_METADATA_HIERARCHY = Method.getMethod((Constructor)ReflectionUtils.getRequiredInternalConstructor(AnnotationMetadataHierarchy.class, (Class[])new Class[]{AnnotationMetadata[].class}));
    private static final Method CONSTRUCTOR_ANNOTATION_VALUE = Method.getMethod((Constructor)ReflectionUtils.getRequiredInternalConstructor(AnnotationValue.class, (Class[])new Class[]{String.class}));
    private static final Method CONSTRUCTOR_ANNOTATION_VALUE_AND_MAP = Method.getMethod((Constructor)ReflectionUtils.getRequiredInternalConstructor(AnnotationValue.class, (Class[])new Class[]{String.class, Map.class}));
    private static final Method CONSTRUCTOR_CLASS_VALUE = Method.getMethod((Constructor)ReflectionUtils.getRequiredInternalConstructor(AnnotationClassValue.class, (Class[])new Class[]{String.class}));
    private static final Method CONSTRUCTOR_CLASS_VALUE_WITH_CLASS = Method.getMethod((Constructor)ReflectionUtils.getRequiredInternalConstructor(AnnotationClassValue.class, (Class[])new Class[]{Class.class}));
    private static final Method CONSTRUCTOR_CLASS_VALUE_WITH_INSTANCE = Method.getMethod((Constructor)ReflectionUtils.getRequiredInternalConstructor(AnnotationClassValue.class, (Class[])new Class[]{Object.class}));
    private static final Type EMPTY_MAP_TYPE = Type.getType(Map.class);
    private static final String EMPTY_MAP = "EMPTY_MAP";
    private static final String LOAD_CLASS_PREFIX = "$micronaut_load_class_value_";
    private final String className;
    private final AnnotationMetadata annotationMetadata;
    private final AnnotationMetadata parent;
    private final boolean writeAnnotationDefaults;

    @Deprecated
    public AnnotationMetadataWriter(String className, ClassElement originatingElement, AnnotationMetadata annotationMetadata, boolean writeAnnotationDefaults) {
        super((Element)originatingElement);
        this.className = className + "$$AnnotationMetadata";
        if (annotationMetadata instanceof DefaultAnnotationMetadata) {
            this.parent = null;
            this.annotationMetadata = annotationMetadata;
        } else if (annotationMetadata instanceof AnnotationMetadataHierarchy) {
            AnnotationMetadataHierarchy hierarchy = (AnnotationMetadataHierarchy)annotationMetadata;
            this.annotationMetadata = hierarchy.getDeclaredMetadata();
            this.parent = hierarchy.getRootMetadata();
        } else {
            throw new ClassGenerationException("Compile time metadata required to generate class: " + className);
        }
        this.writeAnnotationDefaults = writeAnnotationDefaults;
    }

    @Deprecated
    public AnnotationMetadataWriter(String className, ClassElement originatingElement, AnnotationMetadata annotationMetadata) {
        this(className, originatingElement, annotationMetadata, false);
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    public void accept(ClassWriterOutputVisitor outputVisitor) throws IOException {
        ClassWriter classWriter = this.generateClassBytes();
        if (classWriter != null) {
            try (OutputStream outputStream = outputVisitor.visitClass(this.className, this.getOriginatingElements());){
                outputStream.write(classWriter.toByteArray());
            }
        }
    }

    public void writeTo(OutputStream outputStream) {
        try {
            ClassWriter classWriter = this.generateClassBytes();
            this.writeClassToDisk(outputStream, classWriter);
        }
        catch (Throwable e) {
            throw new ClassGenerationException("Error generating annotation metadata: " + e.getMessage(), e);
        }
    }

    @Internal
    public static void instantiateNewMetadata(Type owningType, ClassWriter declaringClassWriter, GeneratorAdapter generatorAdapter, DefaultAnnotationMetadata annotationMetadata, Map<String, GeneratorAdapter> loadTypeMethods) {
        AnnotationMetadataWriter.instantiateInternal(owningType, declaringClassWriter, generatorAdapter, annotationMetadata, true, loadTypeMethods);
    }

    @Internal
    public static void instantiateNewMetadataHierarchy(Type owningType, ClassWriter classWriter, GeneratorAdapter generatorAdapter, AnnotationMetadataHierarchy hierarchy, Map<String, GeneratorAdapter> loadTypeMethods) {
        generatorAdapter.visitTypeInsn(187, TYPE_DEFAULT_ANNOTATION_METADATA_HIERARCHY.getInternalName());
        generatorAdapter.visitInsn(89);
        AnnotationMetadataWriter.pushNewArray(generatorAdapter, AnnotationMetadata.class, 2);
        AnnotationMetadataWriter.pushStoreInArray(generatorAdapter, 0, 2, () -> {
            AnnotationMetadata rootMetadata = hierarchy.getRootMetadata();
            AnnotationMetadataWriter.pushNewAnnotationMetadataOrReference(owningType, classWriter, generatorAdapter, loadTypeMethods, rootMetadata);
        });
        AnnotationMetadataWriter.pushStoreInArray(generatorAdapter, 1, 2, () -> {
            AnnotationMetadata declaredMetadata = hierarchy.getDeclaredMetadata();
            AnnotationMetadataWriter.pushNewAnnotationMetadataOrReference(owningType, classWriter, generatorAdapter, loadTypeMethods, declaredMetadata);
        });
        generatorAdapter.invokeConstructor(TYPE_DEFAULT_ANNOTATION_METADATA_HIERARCHY, CONSTRUCTOR_ANNOTATION_METADATA_HIERARCHY);
    }

    private static void pushNewAnnotationMetadataOrReference(Type owningType, ClassWriter classWriter, GeneratorAdapter generatorAdapter, Map<String, GeneratorAdapter> loadTypeMethods, AnnotationMetadata declaredMetadata) {
        if (declaredMetadata instanceof DefaultAnnotationMetadata) {
            AnnotationMetadataWriter.instantiateNewMetadata(owningType, classWriter, generatorAdapter, (DefaultAnnotationMetadata)declaredMetadata, loadTypeMethods);
        } else if (declaredMetadata instanceof AnnotationMetadataReference) {
            String className = ((AnnotationMetadataReference)declaredMetadata).getClassName();
            Type type = AnnotationMetadataWriter.getTypeReference(className);
            generatorAdapter.getStatic(type, "$ANNOTATION_METADATA", Type.getType(AnnotationMetadata.class));
        } else {
            generatorAdapter.getStatic(Type.getType(AnnotationMetadata.class), "EMPTY_METADATA", Type.getType(AnnotationMetadata.class));
        }
    }

    @Internal
    public static void writeAnnotationDefaults(DefaultAnnotationMetadata annotationMetadata, ClassWriter classWriter, Type owningType, Map<String, GeneratorAdapter> loadTypeMethods) {
        Map<String, Map<CharSequence, Object>> annotationDefaultValues = annotationMetadata.annotationDefaultValues;
        if (CollectionUtils.isNotEmpty(annotationDefaultValues)) {
            MethodVisitor si = classWriter.visitMethod(8, "<clinit>", "()V", null, null);
            GeneratorAdapter staticInit = new GeneratorAdapter(si, 8, "<clinit>", "()V");
            AnnotationMetadataWriter.writeAnnotationDefaults(owningType, classWriter, staticInit, annotationMetadata, loadTypeMethods);
            staticInit.visitInsn(177);
            staticInit.visitMaxs(1, 1);
            staticInit.visitEnd();
        }
    }

    @Internal
    public static void writeAnnotationDefaults(Type owningType, ClassWriter classWriter, GeneratorAdapter staticInit, DefaultAnnotationMetadata annotationMetadata, Map<String, GeneratorAdapter> loadTypeMethods) {
        Map<String, Map<CharSequence, Object>> annotationDefaultValues = annotationMetadata.annotationDefaultValues;
        if (CollectionUtils.isNotEmpty(annotationDefaultValues)) {
            for (Map.Entry<String, Map<CharSequence, Object>> entry : annotationDefaultValues.entrySet()) {
                Map<CharSequence, Object> annotationValues = entry.getValue();
                boolean typeOnly = CollectionUtils.isEmpty(annotationValues);
                String annotationName = entry.getKey();
                if (typeOnly && AnnotationMetadataSupport.getRegisteredAnnotationType(annotationName).isPresent()) continue;
                AnnotationMetadataWriter.invokeLoadClassValueMethod(owningType, (ClassVisitor)classWriter, staticInit, loadTypeMethods, new AnnotationClassValue(annotationName));
                if (!typeOnly) {
                    AnnotationMetadataWriter.pushAnnotationAttributes(owningType, (ClassVisitor)classWriter, staticInit, annotationValues, loadTypeMethods);
                    staticInit.invokeStatic(TYPE_DEFAULT_ANNOTATION_METADATA, METHOD_REGISTER_ANNOTATION_DEFAULTS);
                    continue;
                }
                staticInit.invokeStatic(TYPE_DEFAULT_ANNOTATION_METADATA, METHOD_REGISTER_ANNOTATION_TYPE);
            }
        }
    }

    @Internal
    private static void pushAnnotationAttributes(Type declaringType, ClassVisitor declaringClassWriter, GeneratorAdapter generatorAdapter, Map<? extends CharSequence, Object> annotationData, Map<String, GeneratorAdapter> loadTypeMethods) {
        int totalSize = annotationData.size() * 2;
        AnnotationMetadataWriter.pushNewArray(generatorAdapter, Object.class, totalSize);
        int i = 0;
        for (Map.Entry<? extends CharSequence, Object> entry : annotationData.entrySet()) {
            String memberName = entry.getKey().toString();
            AnnotationMetadataWriter.pushStoreStringInArray(generatorAdapter, i++, totalSize, memberName);
            Object value = entry.getValue();
            AnnotationMetadataWriter.pushStoreInArray(generatorAdapter, i++, totalSize, () -> AnnotationMetadataWriter.pushValue(declaringType, declaringClassWriter, generatorAdapter, value, loadTypeMethods));
        }
        generatorAdapter.invokeStatic(Type.getType(AnnotationUtil.class), METHOD_MAP_OF);
    }

    private static void instantiateInternal(Type owningType, ClassWriter declaringClassWriter, GeneratorAdapter generatorAdapter, DefaultAnnotationMetadata annotationMetadata, boolean isNew, Map<String, GeneratorAdapter> loadTypeMethods) {
        if (isNew) {
            generatorAdapter.visitTypeInsn(187, TYPE_DEFAULT_ANNOTATION_METADATA.getInternalName());
            generatorAdapter.visitInsn(89);
        } else {
            generatorAdapter.loadThis();
        }
        AnnotationMetadataWriter.pushCreateAnnotationData(owningType, declaringClassWriter, generatorAdapter, annotationMetadata.declaredAnnotations, loadTypeMethods, annotationMetadata.getSourceRetentionAnnotations());
        AnnotationMetadataWriter.pushCreateAnnotationData(owningType, declaringClassWriter, generatorAdapter, annotationMetadata.declaredStereotypes, loadTypeMethods, annotationMetadata.getSourceRetentionAnnotations());
        AnnotationMetadataWriter.pushCreateAnnotationData(owningType, declaringClassWriter, generatorAdapter, annotationMetadata.allStereotypes, loadTypeMethods, annotationMetadata.getSourceRetentionAnnotations());
        AnnotationMetadataWriter.pushCreateAnnotationData(owningType, declaringClassWriter, generatorAdapter, annotationMetadata.allAnnotations, loadTypeMethods, annotationMetadata.getSourceRetentionAnnotations());
        AnnotationMetadataWriter.pushCreateAnnotationsByStereotypeData(generatorAdapter, annotationMetadata.annotationsByStereotype);
        generatorAdapter.invokeConstructor(TYPE_DEFAULT_ANNOTATION_METADATA, CONSTRUCTOR_ANNOTATION_METADATA);
    }

    private ClassWriter generateClassBytes() {
        ClassWriter classWriter = new ClassWriter(3);
        Type owningType = AnnotationMetadataWriter.getTypeReferenceForName(this.className, new String[0]);
        this.startClass((ClassVisitor)classWriter, AnnotationMetadataWriter.getInternalName(this.className), TYPE_DEFAULT_ANNOTATION_METADATA);
        GeneratorAdapter constructor = this.startConstructor((ClassVisitor)classWriter);
        DefaultAnnotationMetadata annotationMetadata = (DefaultAnnotationMetadata)this.annotationMetadata;
        HashMap<String, GeneratorAdapter> loadTypeMethods = new HashMap<String, GeneratorAdapter>(5);
        AnnotationMetadataWriter.instantiateInternal(owningType, classWriter, constructor, annotationMetadata, false, loadTypeMethods);
        constructor.visitInsn(177);
        constructor.visitMaxs(1, 1);
        constructor.visitEnd();
        if (this.writeAnnotationDefaults) {
            AnnotationMetadataWriter.writeAnnotationDefaults(annotationMetadata, classWriter, owningType, loadTypeMethods);
        }
        for (GeneratorAdapter adapter : loadTypeMethods.values()) {
            adapter.visitMaxs(3, 1);
            adapter.visitEnd();
        }
        classWriter.visitEnd();
        return classWriter;
    }

    private static void pushCreateListCall(GeneratorAdapter methodVisitor, List<String> names) {
        int totalSize;
        int n = totalSize = names == null ? 0 : names.size();
        if (totalSize > 0) {
            AnnotationMetadataWriter.pushNewArray(methodVisitor, Object.class, totalSize);
            int i = 0;
            for (String name : names) {
                AnnotationMetadataWriter.pushStoreStringInArray(methodVisitor, i++, totalSize, name);
            }
            methodVisitor.invokeStatic(Type.getType(AnnotationUtil.class), METHOD_LIST_OF);
        } else {
            methodVisitor.visitInsn(1);
        }
    }

    private static void pushCreateAnnotationsByStereotypeData(GeneratorAdapter methodVisitor, Map<String, List<String>> annotationData) {
        int totalSize;
        int n = totalSize = annotationData == null ? 0 : annotationData.size() * 2;
        if (totalSize > 0) {
            AnnotationMetadataWriter.pushNewArray(methodVisitor, Object.class, totalSize);
            int i = 0;
            for (Map.Entry<String, List<String>> entry : annotationData.entrySet()) {
                String annotationName = entry.getKey();
                AnnotationMetadataWriter.pushStoreStringInArray(methodVisitor, i++, totalSize, annotationName);
                AnnotationMetadataWriter.pushStoreInArray(methodVisitor, i++, totalSize, () -> AnnotationMetadataWriter.pushCreateListCall(methodVisitor, (List)entry.getValue()));
            }
            methodVisitor.invokeStatic(Type.getType(AnnotationUtil.class), METHOD_MAP_OF);
        } else {
            methodVisitor.visitInsn(1);
        }
    }

    private static void pushCreateAnnotationData(Type declaringType, ClassWriter declaringClassWriter, GeneratorAdapter methodVisitor, Map<String, Map<CharSequence, Object>> annotationData, Map<String, GeneratorAdapter> loadTypeMethods, Set<String> sourceRetentionAnnotations) {
        int totalSize;
        if (annotationData != null) {
            annotationData = new LinkedHashMap<String, Map<CharSequence, Object>>(annotationData);
            for (String sourceRetentionAnnotation : sourceRetentionAnnotations) {
                annotationData.remove(sourceRetentionAnnotation);
            }
        }
        int n = totalSize = annotationData == null ? 0 : annotationData.size() * 2;
        if (totalSize > 0) {
            AnnotationMetadataWriter.pushNewArray(methodVisitor, Object.class, totalSize);
            int i = 0;
            for (Map.Entry<String, Map<CharSequence, Object>> entry : annotationData.entrySet()) {
                String annotationName = entry.getKey();
                AnnotationMetadataWriter.pushStoreStringInArray(methodVisitor, i++, totalSize, annotationName);
                Map<CharSequence, Object> attributes = entry.getValue();
                if (attributes.isEmpty()) {
                    AnnotationMetadataWriter.pushStoreInArray(methodVisitor, i++, totalSize, () -> methodVisitor.getStatic(Type.getType(Collections.class), EMPTY_MAP, EMPTY_MAP_TYPE));
                    continue;
                }
                AnnotationMetadataWriter.pushStoreInArray(methodVisitor, i++, totalSize, () -> AnnotationMetadataWriter.pushAnnotationAttributes(declaringType, (ClassVisitor)declaringClassWriter, methodVisitor, attributes, loadTypeMethods));
            }
            methodVisitor.invokeStatic(Type.getType(AnnotationUtil.class), METHOD_MAP_OF);
        } else {
            methodVisitor.visitInsn(1);
        }
    }

    private static void pushValue(Type declaringType, ClassVisitor declaringClassWriter, GeneratorAdapter methodVisitor, Object value, Map<String, GeneratorAdapter> loadTypeMethods) {
        if (value == null) {
            methodVisitor.visitInsn(1);
        } else if (value instanceof Boolean) {
            methodVisitor.push(((Boolean)value).booleanValue());
            AnnotationMetadataWriter.pushBoxPrimitiveIfNecessary(Boolean.TYPE, (MethodVisitor)methodVisitor);
        } else if (value instanceof String) {
            methodVisitor.push(value.toString());
        } else if (value instanceof AnnotationClassValue) {
            AnnotationClassValue acv = (AnnotationClassValue)value;
            if (acv.isInstantiated()) {
                methodVisitor.visitTypeInsn(187, TYPE_ANNOTATION_CLASS_VALUE.getInternalName());
                methodVisitor.visitInsn(89);
                methodVisitor.visitTypeInsn(187, AnnotationMetadataWriter.getInternalName(acv.getName()));
                methodVisitor.visitInsn(89);
                methodVisitor.invokeConstructor(AnnotationMetadataWriter.getTypeReference(acv.getName()), new Method("<init>", AnnotationMetadataWriter.getConstructorDescriptor(new Object[0])));
                methodVisitor.invokeConstructor(TYPE_ANNOTATION_CLASS_VALUE, CONSTRUCTOR_CLASS_VALUE_WITH_INSTANCE);
            } else {
                AnnotationMetadataWriter.invokeLoadClassValueMethod(declaringType, declaringClassWriter, methodVisitor, loadTypeMethods, acv);
            }
        } else if (value instanceof Enum) {
            Enum enumObject = (Enum)value;
            Class declaringClass = enumObject.getDeclaringClass();
            Type t = Type.getType(declaringClass);
            methodVisitor.getStatic(t, enumObject.name(), t);
        } else if (value.getClass().isArray()) {
            Class componentType = ReflectionUtils.getWrapperType(value.getClass().getComponentType());
            int len = Array.getLength(value);
            AnnotationMetadataWriter.pushNewArray(methodVisitor, componentType, len);
            for (int i = 0; i < len; ++i) {
                Object v = Array.get(value, i);
                AnnotationMetadataWriter.pushStoreInArray(methodVisitor, i, len, () -> AnnotationMetadataWriter.pushValue(declaringType, declaringClassWriter, methodVisitor, v, loadTypeMethods));
            }
        } else if (value instanceof Collection) {
            List<Object> array = Arrays.asList(((Collection)value).toArray());
            int len = array.size();
            if (len == 0) {
                AnnotationMetadataWriter.pushNewArray(methodVisitor, Object.class, len);
            } else {
                boolean first = true;
                for (int i = 0; i < len; ++i) {
                    Object v = array.get(i);
                    if (first) {
                        Class type = v == null ? Object.class : v.getClass();
                        AnnotationMetadataWriter.pushNewArray(methodVisitor, type, len);
                        first = false;
                    }
                    AnnotationMetadataWriter.pushStoreInArray(methodVisitor, i, len, () -> AnnotationMetadataWriter.pushValue(declaringType, declaringClassWriter, methodVisitor, v, loadTypeMethods));
                }
            }
        } else if (value instanceof Long) {
            methodVisitor.push(((Long)value).longValue());
            AnnotationMetadataWriter.pushBoxPrimitiveIfNecessary(Long.TYPE, (MethodVisitor)methodVisitor);
        } else if (value instanceof Double) {
            methodVisitor.push(((Double)value).doubleValue());
            AnnotationMetadataWriter.pushBoxPrimitiveIfNecessary(Double.TYPE, (MethodVisitor)methodVisitor);
        } else if (value instanceof Float) {
            methodVisitor.push(((Float)value).floatValue());
            AnnotationMetadataWriter.pushBoxPrimitiveIfNecessary(Float.TYPE, (MethodVisitor)methodVisitor);
        } else if (value instanceof Number) {
            methodVisitor.push(((Number)value).intValue());
            AnnotationMetadataWriter.pushBoxPrimitiveIfNecessary(ReflectionUtils.getPrimitiveType(value.getClass()), (MethodVisitor)methodVisitor);
        } else if (value instanceof AnnotationValue) {
            AnnotationValue data = (AnnotationValue)value;
            String annotationName = data.getAnnotationName();
            Map values = data.getValues();
            Type annotationValueType = Type.getType(AnnotationValue.class);
            methodVisitor.newInstance(annotationValueType);
            methodVisitor.dup();
            methodVisitor.push(annotationName);
            if (CollectionUtils.isNotEmpty((Map)values)) {
                AnnotationMetadataWriter.pushAnnotationAttributes(declaringType, declaringClassWriter, methodVisitor, values, loadTypeMethods);
                methodVisitor.invokeConstructor(annotationValueType, CONSTRUCTOR_ANNOTATION_VALUE_AND_MAP);
            } else {
                methodVisitor.invokeConstructor(annotationValueType, CONSTRUCTOR_ANNOTATION_VALUE);
            }
        } else {
            methodVisitor.visitInsn(1);
        }
    }

    private static void invokeLoadClassValueMethod(Type declaringType, ClassVisitor declaringClassWriter, GeneratorAdapter methodVisitor, Map<String, GeneratorAdapter> loadTypeMethods, AnnotationClassValue acv) {
        String typeName = acv.getName();
        String desc = AnnotationMetadataWriter.getMethodDescriptor(AnnotationClassValue.class, Collections.emptyList());
        GeneratorAdapter loadTypeGeneratorMethod = loadTypeMethods.computeIfAbsent(typeName, type -> {
            String methodName = LOAD_CLASS_PREFIX + loadTypeMethods.size();
            GeneratorAdapter loadTypeGenerator = new GeneratorAdapter(declaringClassWriter.visitMethod(4104, methodName, desc, null, null), 4104, methodName, desc);
            loadTypeGenerator.visitCode();
            Label tryStart = new Label();
            Label tryEnd = new Label();
            Label exceptionHandler = new Label();
            loadTypeGenerator.visitTryCatchBlock(tryStart, tryEnd, exceptionHandler, Type.getInternalName(Throwable.class));
            loadTypeGenerator.visitLabel(tryStart);
            loadTypeGenerator.visitTypeInsn(187, TYPE_ANNOTATION_CLASS_VALUE.getInternalName());
            loadTypeGenerator.visitInsn(89);
            loadTypeGenerator.push(AnnotationMetadataWriter.getTypeReferenceForName(typeName, new String[0]));
            loadTypeGenerator.invokeConstructor(TYPE_ANNOTATION_CLASS_VALUE, CONSTRUCTOR_CLASS_VALUE_WITH_CLASS);
            loadTypeGenerator.visitLabel(tryEnd);
            loadTypeGenerator.returnValue();
            loadTypeGenerator.visitLabel(exceptionHandler);
            loadTypeGenerator.visitFrame(-1, 0, new Object[0], 1, new Object[]{"java/lang/Throwable"});
            loadTypeGenerator.visitVarInsn(58, 0);
            loadTypeGenerator.visitTypeInsn(187, TYPE_ANNOTATION_CLASS_VALUE.getInternalName());
            loadTypeGenerator.visitInsn(89);
            loadTypeGenerator.push(typeName);
            loadTypeGenerator.invokeConstructor(TYPE_ANNOTATION_CLASS_VALUE, CONSTRUCTOR_CLASS_VALUE);
            loadTypeGenerator.returnValue();
            return loadTypeGenerator;
        });
        methodVisitor.visitMethodInsn(184, declaringType.getInternalName(), loadTypeGeneratorMethod.getName(), desc, false);
    }
}

