/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.DefaultMessageContext;
import io.micronaut.context.exceptions.NoSuchMessageException;
import io.micronaut.core.annotation.Indexed;
import io.micronaut.core.util.ArgumentUtils;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
@Indexed(value=MessageSource.class)
public interface MessageSource {
    public static final MessageSource EMPTY = new MessageSource(){

        @Override
        @NonNull
        public Optional<String> getRawMessage(@NonNull String code, @NonNull MessageContext context) {
            return Optional.empty();
        }

        @Override
        @NonNull
        public String interpolate(@NonNull String template, @NonNull MessageContext context) {
            return template;
        }
    };

    @NonNull
    default public Optional<String> getMessage(@NonNull String code, @NonNull MessageContext context) {
        Optional<String> rawMessage = this.getRawMessage(code, context);
        return rawMessage.map(message -> this.interpolate((String)message, context));
    }

    @NonNull
    default public String getMessage(@NonNull String code, @NonNull MessageContext context, @NonNull String defaultMessage) {
        ArgumentUtils.requireNonNull((String)"defaultMessage", (Object)defaultMessage);
        String rawMessage = this.getRawMessage(code, context, defaultMessage);
        return this.interpolate(rawMessage, context);
    }

    @NonNull
    public Optional<String> getRawMessage(@NonNull String var1, @NonNull MessageContext var2);

    @NonNull
    default public String getRawMessage(@NonNull String code, @NonNull MessageContext context, @NonNull String defaultMessage) {
        ArgumentUtils.requireNonNull((String)"defaultMessage", (Object)defaultMessage);
        return this.getRawMessage(code, context).orElse(defaultMessage);
    }

    @NonNull
    public String interpolate(@NonNull String var1, @NonNull MessageContext var2);

    @NonNull
    default public String getRequiredMessage(@NonNull String code, @NonNull MessageContext context) {
        return this.getMessage(code, context).orElseThrow(() -> new NoSuchMessageException(code));
    }

    @NonNull
    default public String getRequiredRawMessage(@NonNull String code, @NonNull MessageContext context) {
        return this.getRawMessage(code, context).orElseThrow(() -> new NoSuchMessageException(code));
    }

    public static interface MessageContext {
        public static final MessageContext DEFAULT = new MessageContext(){};

        @NonNull
        default public Locale getLocale() {
            return Locale.getDefault();
        }

        @NonNull
        default public Locale getLocale(@Nullable Locale defaultLocale) {
            return defaultLocale != null ? defaultLocale : this.getLocale();
        }

        @NonNull
        default public Map<String, Object> getVariables() {
            return Collections.emptyMap();
        }

        @NonNull
        public static MessageContext of(@Nullable Locale locale) {
            return new DefaultMessageContext(locale, null);
        }

        @NonNull
        public static MessageContext of(@Nullable Map<String, Object> variables) {
            return new DefaultMessageContext(null, variables);
        }

        @NonNull
        public static MessageContext of(@Nullable Locale locale, @Nullable Map<String, Object> variables) {
            return new DefaultMessageContext(locale, variables);
        }
    }
}

