/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.env;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.env.MapPropertySource;
import io.micronaut.context.env.PropertySource;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EnvironmentPropertySource
extends MapPropertySource {
    public static final int POSITION = -200;
    public static final String NAME = "env";

    public EnvironmentPropertySource() {
        super(NAME, EnvironmentPropertySource.getEnv(null, null));
    }

    public EnvironmentPropertySource(@Nullable List<String> includes, @Nullable List<String> excludes) {
        super(NAME, EnvironmentPropertySource.getEnv(includes, excludes));
    }

    public int getOrder() {
        return -200;
    }

    @Override
    public PropertySource.PropertyConvention getConvention() {
        return PropertySource.PropertyConvention.ENVIRONMENT_VARIABLE;
    }

    private static Map getEnv(@Nullable List<String> includes, @Nullable List<String> excludes) {
        Map<String, String> env;
        if (includes != null || excludes != null) {
            env = new HashMap<String, String>(System.getenv());
            Iterator<String> it = env.keySet().iterator();
            while (it.hasNext()) {
                String envVar = it.next();
                if (excludes != null && excludes.contains(envVar)) {
                    it.remove();
                }
                if (includes == null || includes.contains(envVar)) continue;
                it.remove();
            }
        } else {
            env = System.getenv();
        }
        return env;
    }
}

