/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject;

import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.BeanContextConditional;
import io.micronaut.inject.BeanDefinitionReference;
import io.micronaut.inject.ConditionalBeanConfiguration;
import java.util.function.Predicate;

public interface BeanConfiguration
extends AnnotationMetadataProvider,
BeanContextConditional {
    public Package getPackage();

    public String getName();

    public String getVersion();

    default public boolean isWithin(BeanDefinitionReference beanDefinitionReference) {
        return this.isWithin(beanDefinitionReference.getBeanType());
    }

    default public boolean isWithin(String className) {
        String packageName = this.getName();
        int i = className.lastIndexOf(46);
        String pkgName = i > -1 ? className.substring(0, i) : className;
        return pkgName.equals(packageName) || pkgName.startsWith(packageName + ".");
    }

    default public boolean isWithin(Class cls) {
        return this.isWithin(cls.getName());
    }

    @NonNull
    public static BeanConfiguration of(@NonNull Package thePackage, @NonNull Predicate<BeanContext> condition) {
        return BeanConfiguration.of(thePackage.getName(), condition);
    }

    @NonNull
    public static BeanConfiguration of(@NonNull String thePackage, @NonNull Predicate<BeanContext> condition) {
        return new ConditionalBeanConfiguration(thePackage, condition);
    }

    @NonNull
    public static BeanConfiguration disabled(@NonNull String thePackage) {
        return new ConditionalBeanConfiguration(thePackage, beanContext -> false);
    }
}

