/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.conditions;

import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ClassUtils;
import java.util.Arrays;
import java.util.Objects;

@Internal
public record MatchesAbsenceOfClassNamesCondition(String[] classes) implements Condition
{
    @Override
    public boolean matches(ConditionContext context) {
        ClassLoader classLoader = context.getBeanContext().getClassLoader();
        for (String name : this.classes) {
            if (!ClassUtils.isPresent((String)name, (ClassLoader)classLoader)) continue;
            context.fail("Class [" + name + "] is not absent");
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchesAbsenceOfClassNamesCondition that = (MatchesAbsenceOfClassNamesCondition)o;
        return Objects.deepEquals(this.classes, that.classes);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.classes);
    }

    @Override
    public String toString() {
        return "MatchesAbsenceOfClassNamesCondition{classes=" + Arrays.toString(this.classes) + "}";
    }
}

