/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.json.body;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.body.MessageBodyHandler;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.codec.CodecException;
import io.micronaut.json.JsonMapper;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@Singleton
@Produces(value={"application/json", "text/json", "application/hal+json", "application/vnd.github+json", "application/feed+json", "application/problem+json", "application/json-patch+json", "application/merge-patch+json"})
@Consumes(value={"application/json", "text/json", "application/hal+json", "application/vnd.github+json", "application/feed+json", "application/problem+json", "application/json-patch+json", "application/merge-patch+json"})
@BootstrapContextCompatible
public final class JsonMessageHandler<T>
implements MessageBodyHandler<T> {
    private final JsonMapper jsonMapper;

    public JsonMessageHandler(JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    @NonNull
    public JsonMapper getJsonMapper() {
        return this.jsonMapper;
    }

    public boolean isReadable(Argument<T> type, MediaType mediaType) {
        return mediaType != null && mediaType.getExtension().equals("json");
    }

    private static CodecException decorateRead(Argument<?> type, IOException e) {
        return new CodecException("Error decoding JSON stream for type [" + type.getName() + "]: " + e.getMessage(), (Throwable)e);
    }

    public MessageBodyWriter<T> createSpecific(Argument<T> type) {
        return new JsonMessageHandler<T>(this.jsonMapper.createSpecific(type));
    }

    public T read(Argument<T> type, MediaType mediaType, Headers httpHeaders, ByteBuffer<?> byteBuffer) throws CodecException {
        T decoded;
        try {
            decoded = this.jsonMapper.readValue(byteBuffer, type);
        }
        catch (IOException e) {
            throw JsonMessageHandler.decorateRead(type, e);
        }
        if (byteBuffer instanceof ReferenceCounted) {
            ReferenceCounted rc = (ReferenceCounted)byteBuffer;
            rc.release();
        }
        return decoded;
    }

    public T read(Argument<T> type, MediaType mediaType, Headers httpHeaders, InputStream inputStream) throws CodecException {
        try {
            return this.jsonMapper.readValue(inputStream, type);
        }
        catch (IOException e) {
            throw JsonMessageHandler.decorateRead(type, e);
        }
    }

    public boolean isWriteable(Argument<T> type, MediaType mediaType) {
        return mediaType != null && mediaType.getExtension().equals("json");
    }

    private static CodecException decorateWrite(Object object, IOException e) {
        return new CodecException("Error encoding object [" + object + "] to JSON: " + e.getMessage(), (Throwable)e);
    }

    public void writeTo(Argument<T> type, MediaType mediaType, T object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
        outgoingHeaders.set((CharSequence)"Content-Type", (CharSequence)(mediaType != null ? mediaType : MediaType.APPLICATION_JSON_TYPE));
        try {
            this.jsonMapper.writeValue(outputStream, type, object);
        }
        catch (IOException e) {
            throw JsonMessageHandler.decorateWrite(object, e);
        }
    }
}

