/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.json.tree;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.json.tree.JsonContainer;
import io.micronaut.json.tree.JsonNode;
import java.util.List;
import java.util.Map;

@Internal
public class JsonArray
extends JsonContainer {
    private final List<JsonNode> values;

    JsonArray(List<JsonNode> values) {
        this.values = values;
    }

    @Override
    public Object getValue() {
        return this.values.stream().map(JsonNode::getValue).toList();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public JsonNode get(@NonNull String fieldName) {
        return null;
    }

    @Override
    public JsonNode get(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        return this.values.get(index);
    }

    @Override
    @NonNull
    public Iterable<JsonNode> values() {
        return this.values;
    }

    @Override
    @NonNull
    public Iterable<Map.Entry<String, JsonNode>> entries() {
        throw new IllegalStateException("Not an object");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof JsonArray)) return false;
        JsonArray ja = (JsonArray)o;
        if (!ja.values.equals(this.values)) return false;
        return true;
    }

    public int hashCode() {
        return this.values.hashCode();
    }
}

